package com.ebm_ws.infra.bricks.impl.j2ee;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.StringTokenizer;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.xmlmapping.IXmlModelMessage;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator2;

public class BricksServlet extends HttpServlet
{
	private static final String PROCESSOR_ATTR_NAME = "Bricks.Processor";
    private static final long serialVersionUID = 1L;

	private String _charset = "UTF-8";
//	private boolean _haltOnError = false;
	
	private Exception _initException;
	private XmlInstantiator2 _doc;
	private IRequestProcessor _reqProc;
	
	/*
	private static IRequestProcessor _reqProc;
	public static IRequestProcessor getRequestProcessor(HttpSession iSession)
	{
		IRequestProcessor proc = (IRequestProcessor)iSession.getAttribute(PROCESSOR_ATTR_NAME);
		if(proc == null)
			return _reqProc;
		return proc;
	}
	*/
	/**
	 * Bricks Servlet Initialisation
	 */
	public void init() throws ServletException
	{
		System.err.println("BricksServlet Init:");
		
		/*
		System.err.println("servlet info: "+getServletInfo());
		System.err.println("servlet name: "+getServletName());
		System.err.println("server info: "+getServletContext().getServerInfo());
		System.err.println("servlet context name: "+getServletContext().getServletContextName());
		System.err.println("ppty 'user.home': "+System.getProperty("user.home"));
		System.err.println("ppty 'user.dir': "+System.getProperty("user.dir"));
		// servlet info: 
		// servlet name: BricksServlet
		// server info: IBM WebSphere Application Server/5.1
		// servlet context name: STB.war
		// ppty 'user.home': /root
		// ppty 'user.dir': /exec/products/websphere/v5.1/AppServer
		*/
		
		try
		{
			// --- root URI
			/*
			if(getInitParameter("root_uri") != null)
				_rootUri = getInitParameter("root_uri");
			System.err.println(" --> root_uri: "+_rootUri);

			// --- root image URI
			if(getInitParameter("root_img_uri") != null)
				_rootImgUri = getInitParameter("root_img_uri");
			ServletContext imageServletCtx = getServletContext().getContext(_rootImgUri);
			if(imageServletCtx == null)
			{
				System.err.println(" --> warning: servlet not found at URI '"+_rootImgUri+"'.");
			}
			System.err.println(" --> root_img_uri: "+_rootImgUri);
			*/

			// --- halt on error
//			_haltOnError = "true".equals(getInitParameter("halt_on_error"));
//			System.err.println(" --> halt_on_error: "+_haltOnError);
			
			// --- runtime mode
			/*
			boolean developmentMode = "development".equals(getInitParameter("rt_mode"));
developmentMode = true;
			System.err.println(" --> runtime mode: "+(developmentMode ? "development" : "production"));
			*/
			
			// --- charset
			if(getInitParameter("encoding") != null)
			{
				// --- try charset
				try
				{
					Charset.forName(getInitParameter("encoding"));
					_charset = getInitParameter("encoding");
				}
				catch(Exception e)
				{
					System.err.println(" --> Warning: encoding charset '"+getInitParameter("encoding")+"' not found.");
				}
			}
			System.err.println(" --> encoding: "+_charset);
			
			// --- init messages
			/*
			_msgbundle = getInitParameter("msgbundle");
				// --- check the default bundle exists
				if(PropertyResourceBundle.getBundle(_msgbundle) == null)
					throw new ServletException("Default resource bundle '"+_msgbundle+"' not found.");
			
			System.err.println(" --> messages successfully retrieved.");
			*/
			
			// --- instanciate the request processor
			String xmlfile = getInitParameter("xml");
			if(xmlfile == null)
				throw new ServletException("Init Parameter 'xml' unspecified.");
			/*
			InputStream is = getServletContext().getResourceAsStream(xmlfile);
			if(is == null)
				throw new ServletException("xml file '"+xmlfile+"' not found.");
			
			IValidationSupport validSupport = new J2EEValidator(getServletContext());
			_doc = XmlInstantiator.instantiate(is, validSupport);
			is.close();
			*/
			URL url = getServletContext().getResource(xmlfile);
			if(url == null)
				throw new ServletException("xml file '"+xmlfile+"' not found.");
			
			IValidationSupport validSupport = new J2EEValidator(getServletContext());
			_doc = XmlInstantiator2.instantiate(url, validSupport);
			
			System.err.println(" --> web site model '"+xmlfile+"' messages:");
			_doc.dumpMessages(IXmlModelMessage.VALID_WARNING, new PrintWriter(System.err));
			
			if(_doc.getRoot() == null)
			{
				System.err.println(" --> web site root node instantiated from '"+xmlfile+"' is null.");
			}
			else if (!(_doc.getRoot() instanceof IRequestProcessor))
			{
				System.err.println(" --> web site root node instantiated from '"+xmlfile+"' is not a IRequestProcessor: "+_doc.getRoot().getClass().getName());
			}
			else
			{
				_reqProc = (IRequestProcessor)_doc.getRoot();
				System.err.println(" --> web site root node successfully instantiated from '"+xmlfile+"'.");
			}
			
			System.err.println("BricksServlet Init Done.");
		}
		catch(Exception e)
		{
			_initException = e;
			System.err.println("Error while initializing BricksServlet:");
			e.printStackTrace(System.err);
			/*
			if(_initException instanceof ServletException)
				throw (ServletException)_initException;
			else
				throw new ServletException(_initException);
			*/
		}
	}
	private String getCharSet()
	{
		return _charset;
	}
	/*
	private void dumpRequest(HttpServletRequest iRequest)
	{
		System.out.println("    req.getCharacterEncoding(): "+iRequest.getCharacterEncoding());
		System.out.println("    req.getContentType(): "+iRequest.getContentType());
		System.out.println("    req.getContextPath(): "+iRequest.getContextPath());
//		System.out.println("    req.getLocalAddr(): "+iRequest.getLocalAddr());
//		System.out.println("    req.getLocalName(): "+iRequest.getLocalName());
//		System.out.println("    req.getLocalPort(): "+iRequest.getLocalPort());
		System.out.println("    req.getMethod(): "+iRequest.getMethod());
		System.out.println("    req.getPathInfo(): "+iRequest.getPathInfo());
		System.out.println("    req.getPathTranslated(): "+iRequest.getPathTranslated());
		System.out.println("    req.getProtocol(): "+iRequest.getProtocol());
		System.out.println("    req.getQueryString(): "+iRequest.getQueryString());
		System.out.println("    req.getRemoteAddr(): "+iRequest.getRemoteAddr());
		System.out.println("    req.getRemoteHost(): "+iRequest.getRemoteHost());
//		System.out.println("    req.getRemotePort(): "+iRequest.getRemotePort());
		System.out.println("    req.getRemoteUser(): "+iRequest.getRemoteUser());
		System.out.println("    req.getRequestURI(): "+iRequest.getRequestURI());
		System.out.println("    req.getScheme(): "+iRequest.getScheme());
		System.out.println("    req.getServerName(): "+iRequest.getServerName());
		System.out.println("    req.getServerPort(): "+iRequest.getServerPort());
		System.out.println("    req.getServletPath(): "+iRequest.getServletPath());
		System.out.println("    req.getLocale(): "+iRequest.getLocale());
	}
	*/
	/**
	 * Bricks Servlet main service method
	 */
	public void service(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException
	{
		// --- wrap Http objects with Bricks implementations
//System.out.println("BricksServlet.service() ("+iRequest.getMethod()+"): "+request);

		// --- display errors if any
		if(_initException != null || _reqProc == null)
		{
			renderInitErrors(iRequest, iResponse);
		}
		else
		{
			// --- process and render request
			IRequestProcessor processorForUser = (IRequestProcessor)iRequest.getSession().getAttribute(PROCESSOR_ATTR_NAME);
			if(processorForUser == null)
			{
				// --- set current processor
				processorForUser = _reqProc;
				iRequest.getSession().setAttribute(PROCESSOR_ATTR_NAME, processorForUser);
			}
			try
			{
				processorForUser.service(iRequest, iResponse);
			}
			catch(IOException ioe)
			{
				throw ioe;
			}
			catch(Throwable t)
			{
				renderStackPage(iRequest, iResponse, t);
			}
		}
//		request.getOutputStream().flush();
	}
	private void renderInitErrors(HttpServletRequest iRequest, HttpServletResponse iResponse) throws IOException
	{
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
//		PrintWriter htmlWriter;
//		IHtmlWriter htmlWriter = new HtmlWriter(wr);
		
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Initialization Errors</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		htmlWriter.write("</head>\n");
		htmlWriter.write("<body>\n");
		
		if(_doc.getRoot() == null)
		{
			htmlWriter.write("<h1>Web Site Model not initialized.</h1>\n");
		}
		else if(_doc.hasMessages(IXmlModelMessage.VALID_ERROR))
		{
			htmlWriter.write("<h1>Web Site Model has errors.</h1>\n");
			htmlWriter.write("<pre>\n");
			_doc.dumpMessages(IXmlModelMessage.VALID_ERROR, new PrintWriter(htmlWriter));
			htmlWriter.write("</pre>\n");
		}
		
		if(_initException != null)
			renderStack(iRequest, iResponse, htmlWriter, _initException);
		
		htmlWriter.write("</body>");
		htmlWriter.write("</html>");
		htmlWriter.flush();
	}
	private void renderStackPage(HttpServletRequest iRequest, HttpServletResponse iResponse, Throwable iThrowable) throws IOException
	{
//		IHtmlWriter htmlWriter = new HtmlWriter(new OutputStreamWriter(iRequest.getOutputStream(), getCharSet()));
		Writer htmlWriter = new OutputStreamWriter(iResponse.getOutputStream(), getCharSet());
		
		htmlWriter.write("<html>\n");
		htmlWriter.write("<head>\n");
		htmlWriter.write("<title>Error</title>\n");
		htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset="+getCharSet()+"'>\n");
		htmlWriter.write("</head>\n");
		htmlWriter.write("<body bgcolor='#FFFFFF' style='font-family: Verdana' text='#192c8f'>\n" );
		
		renderStack(iRequest, iResponse, htmlWriter, iThrowable);
		
		htmlWriter.write("</body>\n");
		htmlWriter.write("</html>\n");
		htmlWriter.flush();
	}
	private void renderStack(HttpServletRequest iRequest, HttpServletResponse iResponse, Writer writer, Throwable e) throws IOException
	{
		writer.write( "<h3 style='color: #990000;'>"+((e.getMessage()==null)?e.getClass().getName():e.getMessage())+"</h3>\n" );
		writer.write( "Exception type : "+e.getClass().getName()+"<BR>\n" );
		
		// --- dump stack
		StringWriter stackInString= new StringWriter();
		PrintWriter print= new PrintWriter(stackInString);
		e.printStackTrace( print );
		print.close();

		StringTokenizer tokens= new StringTokenizer( stackInString.toString(), "\n" );
		if( tokens.hasMoreElements() ) tokens.nextElement();
		while( tokens.hasMoreElements() )
		{
			String token= tokens.nextToken().trim();
			if( token.startsWith("at ") )
			{
				token= token.substring(3);
				writer.write( "Exception thrown in :<BR><A style='color: #990000;'>"+token+"</A>\n<P>" );
				break;
			}
		}
		tokens= new StringTokenizer( stackInString.toString(), "\n" );

		writer.write( "Stack trace :<BR><UL>\n" );
		if( tokens.hasMoreElements() ) tokens.nextElement();
		while( tokens.hasMoreElements() )
		{
			String token= tokens.nextToken().trim();
			if( token.startsWith("at ") )
				token= token.substring(3);
			else
				continue;
			if( token.indexOf("java.lang.reflect.Method.invoke")>=0 )
				break;
			if( token.indexOf("javax.servlet.http.HttpServlet.service")>=0 )
				break;
			writer.write( "<LI>"+token+"</LI>\n" );
		}
		writer.write( "</UL>\n");

		writer.write( "<A style='text-decoration: underline; cursor: hand;' onClick='stack.style.visibility=\"visible\";'>Show Full Stack</A><BR>\n" );
		writer.write( "<PRE id=stack style='visibility: hidden;'>\n" );
		writer.write( stackInString.toString() );
		writer.write( "\n</PRE>\n" );
		writer.flush();
//		e.printStackTrace();
	}
	// ==================================================================
	// === Properties based messages
	// ==================================================================
	/*
	private Properties loadMessagesFile(String iLanguange)
	{
		try
        {
			String key = iLanguange == null ? "messages" : "messages."+iLanguange;
			String messfile = getInitParameter(key);
//System.out.println("init parameter '"+key+"': ["+messfile+"]");
			if(messfile == null)
				return null;
			InputStream is = getServletContext().getResourceAsStream(messfile);
			if(is == null)
				return null;
	        Properties ppties = new Properties();
	        ppties.load(is);
	        is.close();
	        return ppties;
        }
        catch(Exception e)
        {
        }
        return null;
	}
	private Properties getMessagesFile(String iLanguange)
	{
		if(iLanguange == null)
			return _defaultMsgs;
		Properties msgs = (Properties)_locale2Messages.get(iLanguange);
		if(msgs == null)
		{
			msgs = loadMessagesFile(iLanguange);
			if(msgs == null)
				msgs = _defaultMsgs;
			_locale2Messages.put(iLanguange, msgs);
		}
		return msgs;
	}
	*/

	// ==================================================================
	// === IRendererSupport implementation
	// ==================================================================
	public class J2EEValidator implements IValidationSupport
	{
		private ServletContext _ctx;
		
		public J2EEValidator(ServletContext iImageContext)
		{
			_ctx = iImageContext;
		}
		public ServletContext getServletContext()
		{
			return _ctx;
		}
		public boolean checkResource(String iResourcePath)
		{
			if(_ctx == null)
				return true;
			if(iResourcePath == null)
			    return true;
			if(!iResourcePath.startsWith("/"))
			    iResourcePath = "/"+iResourcePath;
//			return _ctx.getResourceAsStream(iResourcePath) != null;
            try {
                return _ctx.getResource(iResourcePath) != null;
            } catch (MalformedURLException e) {
                return false;
            }
		}
	}
	
}
