package com.ebm_ws.infra.bricks.impl.multiparts;

import java.io.InputStream;

public interface IPart
{
	/**
	 * Returns the uploading file name. 
	 * @return the uploading file name.
	 */
	public String getFileName();
	/**
	 * Returns the uploading file content-type. 
	 * @return the uploading file content-type.
	 */
	public String getFileContentType();
	/**
	 * Returns the uploading file input stream. 
	 * @return the uploading file input stream.
	 */
	public InputStream getFileInputStream();
	/**
	 * Determines whether if the uploading file looks invalid or not.
	 * <p>
	 * This method checks first if the filename is <code>null</code>, and then if the stream is empty (zero bytes).<br>
	 * Obviously a non-null filename with a non-null streamm size is <b>never</b> considered invalid.<br>
	 * <b>Note</b>: A genuine empty file would then appear invalid. This is a limitation of upload client platforms (web browsers).
	 * @return <code>true</code> if the filename is <code>null</code> or if the file is empty (zero bytes).
	 */
	public boolean looksLikeAnInvalidFile();
	
	public boolean isFileUpload();
	
	public String getInputName();
	
	public String getDataInputValue();
}
