package com.ebm_ws.infra.bricks.impl.tools;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;

import javax.servlet.ServletContext;

import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.xmlmapping.IXmlModelMessage;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator2;

public class Validator
{
	public static void main(String[] args)
	{
		if(args.length < 2)
		{
			System.err.println("Usage: Validator <xml> <root web app> [<level>]");
			return;
		}
		
		String xmlFileName = args[0];
		String webRootDirName = args[1];
		String level = args.length > 2 ? args[2] : "w";
		int dumpLevel = IXmlModelMessage.VALID_WARNING;
		if(level.startsWith("e") || level.startsWith("E"))
			dumpLevel = IXmlModelMessage.VALID_ERROR;
		else if(level.startsWith("i") || level.startsWith("I"))
			dumpLevel = IXmlModelMessage.VALID_INFO;
		
		// --- check xmlfile refers to an existing file
		File xmlFile = new File(xmlFileName);
		if(!xmlFile.exists())
		{
			System.err.println("xml file ["+xmlFileName+"] not found.");
			return;
		}
		
		// --- check webRoot exists
		File webRootDir = new File(webRootDirName);
		if(!webRootDir.exists())
		{
			System.err.println("Web App Root directory ["+webRootDirName+"] not found.");
			return;
		}
		File webInfDir = new File(webRootDir, "WEB-INF");
		if(!webInfDir.exists())
		{
			System.err.println("Warning: Directory ["+webRootDirName+"] doesn't look like a Web App Root directory (no WEB-INF found).");
		}
		
		System.out.println("Validating Bricks XML: "+xmlFileName);
		
    	String urlStr = "file:/"+(xmlFile.getAbsolutePath().replace('\\', '/'));
		URL url = null;
        try
        {
//   System.out.println("url: "+urlStr);
	        url = new URL(urlStr);
        }
        catch(MalformedURLException e)
        {
    		System.err.println("Error while building xml file url ["+urlStr+"].");
	        e.printStackTrace(System.err);
	        return;
        }
        try
        {
    		IValidationSupport validSupport = new J2EEValidator(webRootDirName);
        	XmlInstantiator2 doc = XmlInstantiator2.instantiate(url, validSupport);
    		System.out.println(" --> XML Model instantiation done.");
    		System.out.println("Dumping messages ("+(dumpLevel == IXmlModelMessage.VALID_ERROR ? "error" : (dumpLevel == IXmlModelMessage.VALID_WARNING ? "warning" : "info"))+"):");
			doc.dumpMessages(dumpLevel, new PrintWriter(System.out));
        }
        catch(Exception e)
        {
    		System.err.println("Error while instantiating xml model.");
	        e.printStackTrace(System.err);
	        return;
        }
	}
	public static class J2EEValidator implements IValidationSupport
	{
		private String _webRoot;
		
		public J2EEValidator(String iWebRoot)
		{
			_webRoot = iWebRoot.replace('\\', '/');
			if(!_webRoot.endsWith("/"))
				_webRoot = _webRoot+"/";
		}
		public ServletContext getServletContext()
		{
			// TODO Auto-generated method stub
			return null;
		}
		public boolean checkResource(String iResourcePath)
		{
			File f = new File(_webRoot+iResourcePath);
			return f.exists();
		}
	}
}
