// ===================================================================
// === Bricks4WebApps JavaScript Library
// ===================================================================
// === This library is used by the Form components
// ===================================================================

function Form_focusFirstInput(formName)
{
	var form = document.forms[formName];
	for(var i=0; i<form.elements.length; i++)
	{
		if(form.elements[i].nodeName != "INPUT")
			continue;
		if(form.elements[i].type == "hidden")
			continue;
		if(!form.elements[i].focus)
			continue;
		if(!form.elements[i].disabled && !form.elements[i].readOnly)
		{
			// --- focus and place the caret at the end
			form.elements[i].focus();
// no: focusses and selects the field value			form.elements[i].select();
			if(form.elements[i].createTextRange)
			{
				// IE: calling focus() puts the carret at the beginning
				var range = form.elements[i].createTextRange();
				range.collapse(false);
				range.select();
			}
			return;
		}
	}
}
function Checkbox_toggle(checkboxId)
{
	var checkbox = document.getElementById(checkboxId);
	checkbox.checked = !checkbox.checked;
}
function Radio_check(radioId)
{
	var radio = document.getElementById(radioId);
	if(!radio.checked)
		radio.checked = true;
}
function Form_submit(formName, action)
{
	var form = document.forms[formName];
	var actionField = form.elements["action"];
	actionField.value = action;
	form.submit();
}
function DateField_showCalendar(evt, formName, dateFieldName, calendarBaseUrl)
{
	var form = document.forms[formName];
	var dateField = form.elements[dateFieldName];
	var calendarUrl = calendarBaseUrl + (calendarBaseUrl.indexOf('?') < 0 ? "?" : "&") + "selected="+dateField.value;
	var width = 300;
	var height = 200;
	// !!! Doesn't work with doctype transitional
	var calendarWindowRule = findStyleRule(".CalendarWindow");
	if(calendarWindowRule != null)
	{
		if(calendarWindowRule.style.width != null)
			width = parseInt(calendarWindowRule.style.width);
		if(calendarWindowRule.style.height != null)
			height = parseInt(calendarWindowRule.style.height);
	}
	if(width < 100) width = 300;
	if(height < 80) height = 150;
	
	window.open(calendarUrl, "_blank", "titlebar=no,dialog=yes,dependent=yes,status=no,location=no,menubar=no,toolbar=no,resizable=yes,width="+width+",height="+height+",left="+evt.screenX+",top="+evt.screenY);
}
function DateField_setDateAndClose(formName, dateFieldName, date)
{
	if(!opener) return;
	if(!opener.document) return;
	var form = opener.document.forms[formName];
	if(!form) return;
	var dateField = form.elements[dateFieldName];
	if(!dateField) return;
	
	dateField.value = date;
	window.close();
}
function findStyleRule(styleName)
{
	try
	{
		for (var i=0; i<document.styleSheets.length; i++)
		{ 
			var rules = document.all ? document.styleSheets[i].rules : document.styleSheets[i].cssRules;
			for (var j=0; j<rules.length; j++)
			{
				if (rules[j].selectorText == styleName)
					return rules[j];
			}
		}
	}
	catch(e)
	{
	}
	return null;
}