// =======================================================================
// === Tree Functions
// =======================================================================

/**
 * Initializes the tree
 * Expands and selects the path of the document passed with the URL 'doc' argument
 */
function Tree_init(treeId, treeServletUrl)
{
	var treeDiv = document.getElementById(treeId);
	if(!treeDiv)
		return;
	
	treeDiv.servletUrl = treeServletUrl;
}
// ====================================================================================================
// === DOM Creation
// ====================================================================================================
/**
 * Creates a node item in the tree.
 * This function creates the required DOM objects to represent a leaf in the tree.
 */
function Tree_makeItem(parentUL, item)
{
	var itemLI = document.createElement("LI");
	itemLI.id = item.id;
	// --- anchor (for a node)
	if(item.isNode)
	{
		var anchor = document.createElement("A");
		anchor.className = item.isExp ? "anchor exp" : "anchor coll";
		if(anchor.attachEvent)
			anchor.attachEvent("onclick", Tree_onClickAnchor);
		else
			anchor.addEventListener("click", Tree_onClickAnchor, false);
//		anchor.innerHTML = "+";
		anchor.href = "#";
		itemLI.appendChild(anchor);
	}
	// --- icon
	if(item.icon)
	{
		var iconImg = document.createElement("IMG");
		iconImg.src = item.icon;
		itemLI.appendChild(iconImg);
	}
	// --- text
	if(item.url)
	{
		var text = document.createElement("A");
		text.href = url;
		text.className = "label";
		text.appendChild(document.createTextNode(item.text));
		itemLI.appendChild(text);
	}
	else
	{
		var text = document.createElement("SPAN");
		text.className = "label";
		text.appendChild(document.createTextNode(item.text));
		itemLI.appendChild(text);
	}
	
	// --- children (for a node)
	if(item.isNode && item.isExp)
		Tree_makeChildren(itemLI, item.children);
	
	parentUL.appendChild(itemLI);
	
	return itemLI;
}
/**
 * Creates the children elements in the tree.
 * This function creates the required DOM objects to represent a children items in the tree.
 */
function Tree_makeChildren(parentLI, children)
{
	if(children == null || children.length ==0)
		return;
	
	var childrenUL = document.createElement("UL");
//	childrenUL.className = "Tree";
	for(var i=0; i<children.length; i++)
	{
		var itemLI = Tree_makeItem(childrenUL, children[i]);
		if(i == children.length-1)
			itemLI.className = "last";
	}
	
	parentLI.appendChild(childrenUL);
}

// ====================================================================================================
// === Event Handlers
// ====================================================================================================
/**
 * Anchor icon click handler
 * Expands and collapses tree items
 */
function Tree_onClickAnchor(evt)
{
	var anchor = window.event ? event.srcElement : evt.target;
	var nodeLI = getFatherNode("LI", anchor);
	var treeDiv = getFatherNode("DIV", nodeLI);
	if(anchor.className == "anchor coll")
	{
		// --- Expand
		// --- 1: node en mode "loading"
		anchor.className = "anchor";
		var loadingDIV = document.createElement("DIV");
		loadingDIV.className = "loading";
//		loadingDIV.appendChild(document.createTextNode("..."));
		nodeLI.appendChild(loadingDIV);
		
		// --- 2: request
		var req = newXHR();
		var reqUrl = treeDiv.servletUrl+"?action=expand&id="+nodeLI.id;
		req.open("GET", reqUrl , true);//asynchronous
		req.onreadystatechange = function()
		{
			//TODO: passage safe de req, anchor et nodeLI (ou bien utilisation de l'id du father ?)
			if(req.readyState == 4)
			{
				if(req.status == 200 || req.status == 0)
				{
					try {
						var children = eval(req.responseText);
						// --- remove loading
						nodeLI.removeChild(loadingDIV);
						// --- build DOM and change class
						Tree_makeChildren(nodeLI, children);
						anchor.className = "anchor exp";
					} catch (e) {
						alert("Error while parsing JSON response: "+e);
					}
				}
				else
				{
					alert("HTTP error ("+reqUrl+"): "+req.status);
				}
			}
		}
		
		// --- send it (blocking until load completed)
		req.send(null);
	}
	else if(anchor.className == "anchor exp")
	{
		// --- collapse
		var req = newXHR();
		var reqUrl = treeDiv.servletUrl+"?action=collapse&id="+nodeLI.id;
		req.open("GET", reqUrl , true);//asynchronous
		req.send(null);
		
		// --- remove DOM children and change class
		var ul = nodeLI.getElementsByTagName("UL");
		if(ul)
		{
			for(var i=0; i<ul.length; i++)
				nodeLI.removeChild(ul[i]);
		}
		anchor.className = "anchor coll";
	}
	
	// --- prevent default behavior
	if(evt.preventDefault)
		evt.preventDefault();
	else
		evt.returnValue = false;
	return false;
}
