package com.ebm_ws.infra.bricks.session;

import java.util.Enumeration;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.impl.context.BricksSessionImpl;

public abstract class BricksSession
{
	protected static ThreadLocal<HttpServletRequest> _currentRequest = new ThreadLocal<HttpServletRequest>();
	protected static ThreadLocal<HttpServletResponse> _currentResponse = new ThreadLocal<HttpServletResponse>();
	
	public static HttpServletRequest getCurrentRequest()
	{
		return _currentRequest.get();
	}
	public static HttpServletResponse getCurrentResponse()
	{
		return _currentResponse.get();
	}
	
	public static BricksSession getSession(HttpServletRequest iRequest)
	{
//		return (BricksSession)iRequest.getSession().getAttribute("_BRICKS_CTX_");
		return BricksSessionImpl.getSession(iRequest);
	}
	public abstract Locale getLocale();
	
	public abstract ILocaleConfig getLocaleConfig();
	
	public abstract Application getApplication();
	
	public abstract void setAttribute(String iName, Object iValue);
	
	public abstract Object getAttribute(String iName);
	
	public abstract void removeAttribute(String iName);
	
	public abstract Enumeration getAttributeNames();
	
	// ==========================================================
	// === gestion des page context
	// ==========================================================
	public abstract IPageContext getCurrentPageContext();
	
}
