package com.ebm_ws.infra.bricks.session;

import java.util.Enumeration;

import com.ebm_ws.infra.bricks.components.base.page.ctx.IPageContextDef;

public interface IPageContext
{
	boolean isSameContext(IPageContext iContext);
	
	// TODO: hritage des attributs dans les page context ?
	// ex: page d'info peut vouloir rcuprer un argument ou un input du context du dessus.
	/**
	 * Sets an attribute attached to this page context.
	 * This data is cached in session as long as the page lives.
	 * @param iName
	 * @param iValue
	 */
	void setAttribute(String iName, Object iValue);
	
	Object getAttribute(String iName);
	
	void removeAttribute(String iName);
	
	Enumeration getAttributeNames();
	
	/**
	 * Returns the value of the required input parameter
	 * @param iName
	 * @return
	 */
	String getInputParameter(String iName);
	
	IPageContextDef getContextDef();
	
	boolean isNew();

}
