package com.ebm_ws.infra.bricks.table;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.session.BricksSession;


public abstract class TableRenderingContext
{
	/**
	 * Retrieves the current table rendering context.
	 * @param iRequest The HttpServletRequest (may be null)
	 * @return
	 */
	public static TableRenderingContext get(HttpServletRequest iRequest)
	{
		if(iRequest == null)
			iRequest = BricksSession.getCurrentRequest();
		return (TableRenderingContext)iRequest.getAttribute("$context");
	}
	/*
	public abstract String[] getFilters();
	*/
	public abstract boolean hasFilters();

	/**
	 * Returns the filter text for the given column.
	 * @param iColumn
	 * @return
	 */
	public abstract String getFilter(int iColumn);

	/**
	 * Returns the first index.
	 * @return
	 */
	public abstract int getFirstIndex();
	
	/**
	 * Returns the displayed page number.
	 * @return
	 */
	public abstract int getPage();

	/**
	 * Returns the maximum number of results displayed by the table.
	 * A null value means "no limit".
	 * @return
	 */
	public abstract int getRowsPerPage();

	/**
	 * Returns the index of the sorted column.
	 * A negative value means no sorted column.
	 * @return
	 */
	public abstract int getSortColumn();

	/**
	 * Returns the sort direction.
	 * <code>true</code> means ascending, <code>false</code> is descending.
	 * @return
	 */
	public abstract boolean getSortDirection();

	/**
	 * Determines whether the current table rendering context has a sorted column
	 * @return
	 */
	public abstract boolean hasSortedColumn();

	/**
	 * Determines whether the current table rendering context has pagination
	 * @return
	 */
	public abstract boolean hasPagination();

	/**
	 * Allows to set the number of rows.
	 * This is only required in the case of a table that displays in page ranges. 
	 * @param iNumberOfRows
	 */
	public abstract void setRowsCount(int iNumberOfRows);
	
	/**
	 * Allows to adjust the displayed page if the requested page is too high
	 */
	public abstract void setPage(int iPage);
}
