package com.ebm_ws.infra.bricks.trash;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

import com.ebm_ws.infra.bricks.util.HtmlUtils;


public class HtmlWriterImpl extends HtmlUtils
{
	// ==================================================
	// === buffers caching
	// ==================================================
	private static Vector _freeBuffers = new Vector();
	private static int MAX_BUFFERS_IN_CACHE = 256;
	private static int INIT_BUFFER_SIZE = 1024;
	
	private StringBuffer _buffer;
	/*
	 * Returns the string buffer.
	 * Manages cache.
	 */
	private StringBuffer getBuffer()
	{
		if(_buffer == null)
		{
			// --- look for a buffer in cache
			synchronized(_freeBuffers)
	        {
				if(_freeBuffers.size() > 0)
				{
					_buffer = (StringBuffer)_freeBuffers.lastElement();
//					_freeBuffers.removeElementAt(_freeBuffers.size()-1);
					// faster?
					_freeBuffers.setSize(_freeBuffers.size()-1);
				}
	        }
			if(_buffer == null)
			{
				// --- no buffer available in cache: create
				_buffer = new StringBuffer(INIT_BUFFER_SIZE);
			}
		}
		return _buffer;
	}
	/*
	 * Releases the string buffer.
	 * Manages cache.
	 */
	private void releaseBuffer()
	{
		if(_buffer != null)
		{
			_buffer.setLength(0);
			synchronized(_freeBuffers)
	        {
				if(_freeBuffers.size() < MAX_BUFFERS_IN_CACHE)
					_freeBuffers.addElement(_buffer);
	        }
			_buffer = null;
		}
	}
	public void flush() throws IOException
	{
	}
	public void write(char[] cbuf, int off, int len) throws IOException
	{
		getBuffer().append(cbuf, off, len);
	}
	// ==================================================
	// === HtmlWriter class
	// ==================================================
	
//	public HtmlWriter(Writer iWriter)
	public HtmlWriterImpl()
	{
//		_writer = iWriter;
//		_writer = new StringBuffer(1000);
	}
	public void writeComment(String iComment) throws IOException
	{
		print("<!-- ========== ");
		print(encode2HTML(iComment));
		println(" ========== -->");
	}
	public void print(String iHTML) throws IOException
	{
		if(iHTML == null) iHTML = "@null@";
		getBuffer().append(iHTML);
	}
	public void println(String iHTML) throws IOException
	{
		getBuffer().append(iHTML).append('\n');
	}
	public void flush(Writer iWriter) throws IOException
	{
		if(_buffer != null)
		{
			iWriter.write(_buffer.toString());
			releaseBuffer();
			iWriter.flush();
		}
	}
	public void close()
	{
		releaseBuffer();
	}
	public int getPosition()
	{
		if(_buffer == null)
			return 0;
		return _buffer.length();
	}
	public void rollbackToPosition(int iPosition)
	{
		if(_buffer != null)
			_buffer.setLength(iPosition);
	}
	protected void finalize() throws Throwable
	{
		releaseBuffer();
	}
}
