/*------------------------------------------------------------------------------
 * FT / ROSI / DPS
 *------------------------------------------------------------------------------
 * Project     : MLTV2
 * Sub-Project : Portail Web
 *------------------------------------------------------------------------------
 * File        : $Workfile$
 * Author      : Pierre SMEYERS
 * 
 * Description :
 *   Specialized writer for writing HTML content.
 *   Contains dedicated helper methods.
 *------------------------------------------------------------------------------
 * $Log: IHtmlWriter.java,v $
 * Revision 1.1.2.5  2006/12/01 12:27:52  mltal
 * Extension de Bricks pour prendre en charge des pages dynamiques (non dclares).
 * Application aux pages identification.jsp & codeInput.jsp --> Authentication / failure.jsp --> Message
 *
 * Revision 1.1.2.4  2006/10/18 12:18:43  mltycdo
 * Dvelopement du Menu Barker pour la page MyVideoClub
 *
 * Revision 1.1.2.3  2006/10/09 14:02:41  mltycdo
 * Encodage du HTML dynamique pour supporter les double quotes
 *
 * Revision 1.1.2.2  2006/09/29 13:06:15  mltal
 * divers
 *
 * Revision 1.1.2.1  2006/09/01 12:57:24  mltal
 * Refactoring and new components.
 *
 * Revision 1.1.2.3  2006/08/25 15:40:49  mltal
 * 1) ANT task for Bricks: generate Mockup, generate XSD, convert JSP 2 Java, generate Javadoc
 * 2) lots of refactoring of Bricks framework (Portal components moved into 'components' package)
 * 3) several new Zac implemented: Credit, Messages, ActuTV
 *
 * Revision 1.1.2.2  2006/08/21 14:47:05  mltal
 * Javadoc and comments.
 *
 */
package com.ebm_ws.infra.bricks.trash;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
/**
 * Specialized writer for writing HTML content.<br>
 * Contains dedicated helper methods.
 */
public abstract class IHtmlWriter extends Writer
{
	/**
	 * Writes HTML code
	 * @param iHTML HTML code
	 * @throws IOException
	 */
	public abstract void print(String iHTML) throws IOException;
	
	/**
	 * Writes an HTML comment
	 * @param iComment Comment text
	 * @throws IOException
	 */
	public abstract void writeComment(String iComment) throws IOException;
	
	/**
	 * Writes HTML code and adds a newline character
	 * @param iHTML HTML code
	 * @throws IOException
	 */
	public abstract void println(String iHTML) throws IOException;
	
	public abstract int getPosition();
	
	public abstract void rollbackToPosition(int iPosition);
	/*
	 * Flushes the writer
	 * @throws IOException
	 */
//	public abstract void flush() throws IOException;
	
	public void writeStack(Throwable iThrowable) throws IOException
	{
		// --- 1: title is the exception message (or classname)
		print( "<p style='font-size: 10pt; color: black;'>" );
		print( "<span style='font-size: 12pt; color: #FF9933;'>" );
		if(iThrowable.getMessage() == null)
			print(iThrowable.getClass().getName());
		else
			print(iThrowable.getMessage());
		print( "</span>\n" );
		print( "<br/>\n" );
		
		// --- 2: exception type (classname)
		print( "Exception type : " );
		print( iThrowable.getClass().getName() );
		print( "<br/>\n" );
		
		// --- 3: exception origin
		StringWriter stackInString= new StringWriter();
		PrintWriter print= new PrintWriter(stackInString);
		iThrowable.printStackTrace( print );
		print.close();

		StringTokenizer tokens= new StringTokenizer( stackInString.toString(), "\n" );
		if( tokens.hasMoreElements() ) tokens.nextElement();
		while( tokens.hasMoreElements() )
		{
			String token= tokens.nextToken().trim();
			if( token.startsWith("at ") )
			{
				token= token.substring(3);
				print("Exception thrown in : ");
				print("<span style='font-size: 12px; color: #FF9933;'>");
//				write(shortenClass(token));
				print(token);
				print("</span>\n");
				print("<br/>\n");
				break;
			}
		}
		tokens= new StringTokenizer( stackInString.toString(), "\n" );

		// --- 4: short stack trace
		/*
		write("Stack trace :\n");
		write("<UL style='font-size: 10px; color: white;'>\n");
		if( tokens.hasMoreElements() ) tokens.nextElement();
		while( tokens.hasMoreElements() )
		{
			String token= tokens.nextToken().trim();
			if( token.startsWith("at ") )
				token= token.substring(3);
			else
				continue;
			if( token.indexOf("java.lang.reflect.Method.invoke")>=0 )
				break;
			if( token.indexOf("javax.servlet.http.HttpServlet.service")>=0 )
				break;
			write( "<LI>"+shortenClass(token)+"</LI>\n" );
		}
		write( "</UL>\n");
		*/

		// --- 5: expandable full stack trace
		print( "<span style='font-size: 12px; color: #FF9933; text-decoration: underline; cursor: hand;' onclick='stack.style.display=\"block\";'>Show Full Stack</span><br/>\n" );
		print( "<pre id=stack style='font: sans-serif; font-size: 8pt; color: black; display: none;'>\n" );
		print( stackInString.toString() );
		print( "\n</pre>\n" );
		print( "</p>\n" );
	}
	/*
	private static String[][] PACKAGE_2_ALIAS = {
		{ "com.francetelecom.malignetv.portail.presentation.bricks", "[mltv_bricks]"},
		{ "com.francetelecom.malignetv.portail", "[mltv]"},
		{ "thalesbm.hydra.business", "[tbm_biz]"},
		{ "thalesbm.hydra.presentation.gui", "[tbm_gui]"},
		{ "thalesbm.hydra", "[tbm]"},
		{ "org.apache.struts", "[struts]"}
	};
	private String shortenClass(String iClassName)
	{
		for(int i=0; i<PACKAGE_2_ALIAS.length; i++)
		{
			if(iClassName.startsWith(PACKAGE_2_ALIAS[i][0]))
				return PACKAGE_2_ALIAS[i][1]+iClassName.substring(PACKAGE_2_ALIAS[i][0].length());
		}
		return iClassName;
	}
	*/

	/**
	 * Encodes the given Java String to HTML encoding.
	 * @param text Java String
	 * @param iNBSP tells whether to translate white spaces into non-breaking spaces or not
	 * @return The encoded HTML string
	 */
	public static String encode2HTML(String text, boolean iNBSP)
	{
		int nbChars = text.length();
		StringBuffer sb = new StringBuffer(nbChars);
		for(int i=0; i<nbChars; i++)
		{
			char c = text.charAt(i);
			if(iNBSP && c == ' ')
			{
				sb.append("&nbsp;");
			}
			else
			{
				switch(c)
				{
				case '\n': // \n turned into <br>
					sb.append("<br>");
					break;
				case '\r': // \r turned into braking whitespace
					sb.append(" ");
					break;
				case '\t': // TAB is turned into 4 non-braking spaces
					sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
					break;
				case '<':
					sb.append("&lt;");
					break;
				case '>':
					sb.append("&gt;");
					break;
				case '\"':
					sb.append("&quot;");
					break;
				default:
					sb.append(c);
					break;
				}
			}
		}
		return sb.toString();
	}
	public static String encode2JsString(String text)
	{
		int nbChars = text.length();
		StringBuffer sb = new StringBuffer(nbChars);
		for(int i=0; i<nbChars; i++)
		{
			char c = text.charAt(i);
			switch(c)
			{
				case '\n':
					sb.append("\\n");
					break;
				case '\r':
					sb.append("\\r");
					break;
				case '\t':
					sb.append("\\t");
					break;
				case '\"':
					sb.append("\\\"");
					break;
				case '\'':
					sb.append("\\'");
					break;
				default:
					sb.append(c);
					break;
			}
		}
		return sb.toString();
	}
}
