package com.ebm_ws.infra.bricks.util;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.enums.Scope;
import com.ebm_ws.infra.bricks.session.BricksSession;

public class BeanUtils
{
	/**
	 * Returns the bean instance from the name declared in the Bricks xml.
	 * @param iRequest
	 * @param iBeanName The bean name registered in Bricks configuration.
	 * @return
	 * @throws Exception
	 */
	public static Object getBricksBean(HttpServletRequest iRequest, String iBeanName) throws Exception
	{
		BricksSession session = BricksSession.getSession(iRequest);
		/*
		DataSource dataSource = session.getApplication().getDataSource(iBeanName);
		if(dataSource == null)
			throw new Exception("Bean '"+iBeanName+"' not found.");
		if(!(dataSource instanceof Bean))
			throw new Exception("DataSource '"+iBeanName+"' is not a Bean.");
		return ((Bean)dataSource).getObject(iRequest);
		*/
		return session.getApplication().getBeanValue(iRequest, iBeanName);
	}
	public static Object getBean(HttpServletRequest iRequest, Class iClass, String iName, Scope iScope)
	{
		String name = iName == null ? iClass.getName() : iName;
		// --- 1: get from cache
		Object obj = null;
		if(iScope == Scope.Request)
		{
			obj = iRequest.getAttribute(name);
		}
		else if(iScope == Scope.Session)
		{
			obj = iRequest.getSession().getAttribute(name);
		}
		else if(iScope == Scope.Application)
		{
			obj = iRequest.getSession().getServletContext().getAttribute(name);
		}
		else if(iScope == Scope.PageContext)
		{
			BricksSession session = BricksSession.getSession(iRequest);
			obj = session.getCurrentPageContext().getAttribute(name);
		}
		
		return obj;
	}
	public static void setBean(HttpServletRequest iRequest, Object iBean, String iName, Scope iScope)
	{
		String name = iName == null ? iBean.getClass().getName() : iName;
		if(iScope == Scope.Request)
		{
			iRequest.setAttribute(name, iBean);
		}
		else if(iScope == Scope.Session)
		{
			iRequest.getSession().setAttribute(name, iBean);
		}
		else if(iScope == Scope.Application)
		{
			iRequest.getSession().getServletContext().setAttribute(name, iBean);
		}
		else if(iScope == Scope.PageContext)
		{
			BricksSession session = BricksSession.getSession(iRequest);
			session.getCurrentPageContext().setAttribute(name, iBean);
		}
	}
}
