/*------------------------------------------------------------------------------
 * FT / ROSI / DPS
 *------------------------------------------------------------------------------
 * Project     : MLTV2
 * Sub-Project : Portail Web
 *------------------------------------------------------------------------------
 * File        : $Workfile$
 * Author      : Pierre SMEYERS
 * 
 * Description :
 *   Helper interface for building Urls with parameters.
 *------------------------------------------------------------------------------
 * $Log: IUrlFactory.java,v $
 * Revision 1.1.2.3  2006/12/01 12:27:52  mltal
 * Extension de Bricks pour prendre en charge des pages dynamiques (non dclares).
 * Application aux pages identification.jsp & codeInput.jsp --> Authentication / failure.jsp --> Message
 *
 * Revision 1.1.2.2  2006/08/21 14:47:05  mltal
 * Javadoc and comments.
 *
 */
package com.ebm_ws.infra.bricks.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

import com.ebm_ws.infra.bricks.impl.UrlWatcher;

/**
 * Helper interface for building Urls with parameters.
 */
public class UrlBuilder
{
	protected String _requestUri;
	protected Hashtable _params;
	
	public UrlBuilder(String iRequestURI)
	{
		_requestUri = iRequestURI;
	}
	public String getRequestUri()
	{
		return _requestUri;
	}
	/**
	 * Sets the given Url parameter.
	 * @param iName Parameter name.
	 * @param iValue Parameter value.
	 * @return Returns this object, to allows chaining calls.
	 */
	public UrlBuilder setParameter(String iName, String iValue)
	{
		if(iName != null)
		{
			if(_params == null)
				_params = new Hashtable();
			if(iValue == null)
// non				_params.remove(iName);
				_params.put(iName, "");
			else
				_params.put(iName, iValue);
		}
		return this;
	}
	public UrlBuilder removeParameter(String iName)
	{
		if(_params != null)
			_params.remove(iName);
		return this;
	}
	public Enumeration getParameterNames()
	{
		if(_params == null)
			return null;
		return _params.keys();
	}
	public String getParameterValue(String iName)
	{
		return (String)_params.get(iName);
	}

	/**
	 * Serializes the Url to its string form.
	 * @return The Url with all its parameters.
	 */
	public String toUrl(String iCharSet, boolean iEncodeHtml)
	{
		StringBuffer sb = new StringBuffer(getRequestUri());
		if(_params != null)
		{
			int i=0;
			Enumeration keys = _params.keys();
			while(keys.hasMoreElements())
			{
				String name = (String)keys.nextElement();
				String value = (String)_params.get(name);
				if(i == 0)
					sb.append('?');
				else
					sb.append(iEncodeHtml ? "&amp;" : "&");
					
				sb.append(name);
				sb.append('=');
				if(iCharSet != null)
				{
					try
	                {
						value = URLEncoder.encode(value, iCharSet);
	                }
	                catch(UnsupportedEncodingException e)
	                {
		                e.printStackTrace();
	                }
				}
                sb.append(value);
				i++;
			}
		}
		if(UrlWatcher.getInstalled() != null)
			UrlWatcher.getInstalled().addUrl(sb.toString());
		return sb.toString();
	}
}
