package com.ebm_ws.infra.bricks.validation;

import javax.servlet.http.HttpServletRequest;

import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;

public class LocalizedMessage implements IValidationMessage
{
	private String _msgProvider;
	private String _key;
	private Object[] _args;
	
	public LocalizedMessage(String iKey, String iMessageProvider, Object[] iArguments)
	{
		_msgProvider = iMessageProvider;
		_key = iKey;
		_args = iArguments;
	}
	public LocalizedMessage(String iKey, Object[] iArguments)
	{
		this(iKey, null, iArguments);
	}
	public LocalizedMessage(String iKey, String iMessageProvider)
	{
		this(iKey, iMessageProvider, null);
	}
	public LocalizedMessage(String iKey)
	{
		this(iKey, null, null);
	}
	public String getMessage(HttpServletRequest iRequest)
	{
		BricksSession session = BricksSession.getSession(iRequest);
		MessageProvider provider = session.getApplication().getMessageProvider(_msgProvider);
		if(provider == null)
			return "!"+_key+"!";
		return provider.getMessage(session.getLocale(), _key, _args);
	}
}
