package com.ebm_ws.infra.bricks.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ValidationErrors extends Exception
{
    private static final long serialVersionUID = 1L;

	private static String GLOBAL_ID = "_";
	
	private HashMap<String,ArrayList<IValidationMessage>> name2Messages = null;
	
	public void addErrors(ValidationErrors iErrors)
	{
		if(name2Messages == null)
			name2Messages = new HashMap<String, ArrayList<IValidationMessage>>();
		
		for(Iterator<String> ids = iErrors.name2Messages.keySet().iterator(); ids.hasNext(); )
		{
			String id = ids.next();
			ArrayList<IValidationMessage> messagesToAdd = iErrors.name2Messages.get(id);
			List<IValidationMessage> existingMessages = getItemErrors(id);
			if(existingMessages == null)
				name2Messages.put(id, messagesToAdd);
			else
				existingMessages.addAll(messagesToAdd);
		}
	}
	public void addGlobalError(IValidationMessage iError)
	{
		addItemError(GLOBAL_ID, iError);
	}
	public void addItemError(String id, IValidationMessage iError)
	{
		if(name2Messages == null)
			name2Messages = new HashMap<String, ArrayList<IValidationMessage>>();
		
		ArrayList<IValidationMessage> messages = name2Messages.get(id);
		if(messages == null)
		{
			messages = new ArrayList<IValidationMessage>(1);
			name2Messages.put(id, messages);
		}
		messages.add(iError);
	}
	public List<IValidationMessage> getGlobalErrors()
	{
		return getItemErrors(GLOBAL_ID);
	}
	public List<IValidationMessage> getItemErrors(String id)
	{
		if(name2Messages == null)
			return null;
		return name2Messages.get(id);
	}
	public boolean hasErrors()
	{
		if(name2Messages == null)
			return false;
		return name2Messages.size() > 0;
	}
	public boolean hasGlobalErrors()
	{
		return hasItemErrors(GLOBAL_ID);
	}
	public boolean hasItemErrors(String iID)
	{
		List<IValidationMessage> errors = getItemErrors(iID);
		return errors != null && errors.size() > 0;
	}
}
