/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base;

import com.ebm_ws.infra.bricks.components.base.RuleDefinition;
import com.ebm_ws.infra.bricks.components.base.binding.IDataSource;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.error.DefaultErrorHandler;
import com.ebm_ws.infra.bricks.components.base.error.ErrorHandler;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.locale.ILocaleSelector;
import com.ebm_ws.infra.bricks.components.base.locale.LocaleConfig;
import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.components.base.msg.ResourceBundle;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.bricks.impl.context.BricksSessionImpl;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.session.IPageContext;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Application
implements IRequestProcessor,
IXmlObject,
IBeanProvider {
    private static Log logger = LogFactory.getLog(Application.class);
    private static final String HANDLER_PARAMNAME = "_hdl_";
    private String _xmlattr_req_HomePage;
    private LocaleConfig[] _xmlnode_1_unb_SupportedLocales;
    private ILocaleSelector _xmlnode_req_LocaleSelector;
    private MessageProvider[] _xmlnode_1_unb_MessagesProviders;
    private ErrorHandler _xmlnode_opt_ErrorHandler = new DefaultErrorHandler();
    private IDataSource[] _xmlnode_0_unb_GlobalBeans;
    private RuleDefinition[] _xmlnode_0_unb_Rules;
    private IFrame[] _xmlnode_1_unb_Frames;
    private IPage[] _xmlnode_1_unb_Pages;
    private ServletContext _servletContext;
    private long startupTime = System.currentTimeMillis();
    private static long EXPIRATION_DELAY = 86400000L;
    private HashMap<String, ILocaleConfig> _code2LocaleConfig = new HashMap();
    private HashMap<String, IPage> _name2Page = new HashMap();
    private ResourceBundle _bricksMessages = new ResourceBundle(BricksMessages.getBundleBaseName());
    private static Class[] SERVICE_METHOD_SIGNATURE = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private Hashtable<String, Object> _id2Handler = new Hashtable();
    private Hashtable<Object, String> _handler2Id = new Hashtable();

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        this._servletContext = ((IValidationSupport)iValidSupport).getServletContext();
        if (this._xmlnode_0_unb_Rules != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < this._xmlnode_0_unb_Rules.length; ++i) {
                if (this._xmlnode_0_unb_Rules[i].getName() == null) continue;
                if (ids.contains(this._xmlnode_0_unb_Rules[i].getName())) {
                    iErrors.logMessage((IXmlObject)this, "Rules", 1, "More than one rules with name '" + this._xmlnode_0_unb_Rules[i].getName() + "'.");
                    continue;
                }
                ids.add(this._xmlnode_0_unb_Rules[i].getName());
            }
        }
        if (this._xmlnode_1_unb_Pages != null) {
            for (int i = 0; i < this._xmlnode_1_unb_Pages.length; ++i) {
                if (this._xmlnode_1_unb_Pages[i] == null || this._xmlnode_1_unb_Pages[i].getName() == null) continue;
                if (this._name2Page.get(this._xmlnode_1_unb_Pages[i].getName()) != null) {
                    iErrors.logMessage((IXmlObject)this._xmlnode_1_unb_Pages[i], "Pages", 1, "More than one page with name '" + this._xmlnode_1_unb_Pages[i].getName() + "'.");
                    continue;
                }
                this._name2Page.put(this._xmlnode_1_unb_Pages[i].getName(), this._xmlnode_1_unb_Pages[i]);
            }
        }
        if (this._xmlattr_req_HomePage == null) {
            iErrors.logMessage((IXmlObject)this, "HomePage", 1, "No HomePage defined.");
        } else if (this.getHomePage() == null) {
            iErrors.logMessage((IXmlObject)this, "HomePage", 1, "HomePage '" + this._xmlattr_req_HomePage + "' does not exist.");
        }
        for (int i = this._xmlnode_1_unb_SupportedLocales.length - 1; i >= 0; --i) {
            Locale loc = this._xmlnode_1_unb_SupportedLocales[i].getLocale();
            this._code2LocaleConfig.put(loc.getLanguage(), this._xmlnode_1_unb_SupportedLocales[i]);
            if (loc.getCountry() == null || loc.getCountry().length() <= 0) continue;
            this._code2LocaleConfig.put(loc.getLanguage() + "_" + loc.getCountry(), this._xmlnode_1_unb_SupportedLocales[i]);
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public IPage getHomePage() {
        return this.getPage(this._xmlattr_req_HomePage);
    }

    public MessageProvider getMessageProvider(String iProviderName) {
        if (this._xmlnode_1_unb_MessagesProviders != null) {
            if (iProviderName == null) {
                return this._xmlnode_1_unb_MessagesProviders[0];
            }
            for (int i = 0; i < this._xmlnode_1_unb_MessagesProviders.length; ++i) {
                if (!iProviderName.equals(this._xmlnode_1_unb_MessagesProviders[i].getName())) continue;
                return this._xmlnode_1_unb_MessagesProviders[i];
            }
        }
        if ("bricks".equals(iProviderName)) {
            return this._bricksMessages;
        }
        return null;
    }

    public IBoolExpr getRule(String iName) {
        if (this._xmlnode_0_unb_Rules == null) {
            return null;
        }
        if (iName == null) {
            return null;
        }
        for (int i = 0; i < this._xmlnode_0_unb_Rules.length; ++i) {
            if (!iName.equals(this._xmlnode_0_unb_Rules[i].getName())) continue;
            return this._xmlnode_0_unb_Rules[i].getBoolExpr();
        }
        return null;
    }

    public IFrame getFrame(String iFrameName) {
        if (this._xmlnode_1_unb_Frames == null) {
            return null;
        }
        if (iFrameName == null) {
            return this._xmlnode_1_unb_Frames[0];
        }
        for (int i = 0; i < this._xmlnode_1_unb_Frames.length; ++i) {
            if (!iFrameName.equals(this._xmlnode_1_unb_Frames[i].getName())) continue;
            return this._xmlnode_1_unb_Frames[i];
        }
        return null;
    }

    public IPage getPage(String iPageName) {
        if (iPageName == null) {
            iPageName = this._xmlattr_req_HomePage;
        }
        return this._name2Page.get(iPageName);
    }

    public ILocaleConfig[] getAllLanguages() {
        return this._xmlnode_1_unb_SupportedLocales;
    }

    public ILocaleConfig getLocaleConfig(Locale iLocale) {
        ILocaleConfig config;
        if (iLocale == null) {
            return this._xmlnode_1_unb_SupportedLocales[0];
        }
        if (iLocale.getCountry() != null && iLocale.getCountry().length() > 0 && (config = this._code2LocaleConfig.get(iLocale.getLanguage() + "_" + iLocale.getCountry())) != null) {
            return config;
        }
        config = this._code2LocaleConfig.get(iLocale.getLanguage());
        if (config != null) {
            return config;
        }
        return this._xmlnode_1_unb_SupportedLocales[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest iRequest, HttpServletResponse iResponse) throws IOException {
        block43: {
            logger.debug((Object)("service(): " + iRequest.getRequestURL()));
            BricksUrlBuilder requestUri = BricksUrlBuilder.copyFromRequest(iRequest, false);
            boolean isHtml = true;
            try {
                BricksSessionImpl.enterRequest(iRequest, iResponse);
                BricksSessionImpl session = BricksSessionImpl.getSession(iRequest);
                if (session == null) {
                    session = new BricksSessionImpl(this);
                    BricksSessionImpl.setSession(iRequest, session);
                }
                if (session.getLocaleConfig() != null) {
                    iRequest.setCharacterEncoding(session.getLocaleConfig().getCharSet());
                }
                Locale localeFromPolicy = this._xmlnode_req_LocaleSelector.getLocale(iRequest);
                ILocaleConfig localeConfig = this.getLocaleConfig(localeFromPolicy);
                if (localeFromPolicy == null) {
                    localeFromPolicy = localeConfig.getLocale();
                }
                session.setLocaleConfig(localeConfig);
                iResponse.setLocale(localeFromPolicy);
                if (requestUri.getSelector() == null || requestUri.getSelector().equals("page")) {
                    IPage page;
                    String pageName = requestUri.getPath();
                    if ("Error".equals(pageName)) {
                        this._xmlnode_opt_ErrorHandler.servePage(iRequest, iResponse);
                        break block43;
                    }
                    String handler = iRequest.getParameter(HANDLER_PARAMNAME);
                    if (handler != null) {
                        int i = handler.lastIndexOf(46);
                        String actionHandlerId = handler.substring(0, i);
                        String actionHandlerMethod = handler.substring(i + 1);
                        Object obj = this.getHandler(actionHandlerId);
                        Method m = obj.getClass().getMethod(actionHandlerMethod, SERVICE_METHOD_SIGNATURE);
                        m.invoke(obj, iRequest, iResponse);
                        if (iResponse.isCommitted()) {
                            return;
                        }
                    }
                    if ((page = this.getPage(pageName)) == null) {
                        logger.debug((Object)("Page '" + pageName + "' not found."));
                        iResponse.sendError(404);
                        return;
                    }
                    if (!page.getContextDef().isAuthorized(iRequest)) {
                        logger.debug((Object)("Page '" + pageName + "' not authorized."));
                        iResponse.sendError(401);
                        return;
                    }
                    IPageContext context = page.getContextDef().extractContext(iRequest);
                    if (!context.isSameContext(session.getCurrentPageContext())) {
                        if (session.getCurrentPageContext() != null) {
                            session.getCurrentPageContext().getContextDef().quit(iRequest);
                        }
                        session.setCurrentPageContext(context);
                        try {
                            context.getContextDef().load(iRequest);
                        }
                        catch (Throwable t) {
                            session.setCurrentPageContext(null);
                            throw t;
                        }
                    }
                    context = session.getCurrentPageContext();
                    page.servePage(iRequest, iResponse);
                    break block43;
                }
                if (requestUri.getSelector().equals("srv")) {
                    isHtml = false;
                    String[] rendererTokens = requestUri.getPathTokens();
                    if (rendererTokens == null || rendererTokens.length != 2) {
                        logger.error((Object)("Invalid Path in Service Request: " + requestUri.getPath()));
                        iResponse.sendError(500);
                        return;
                    }
                    String rendererId = rendererTokens[0];
                    String rendererMethod = rendererTokens[1];
                    Object renderer = this.getHandler(rendererId);
                    Method serviceMethod = renderer.getClass().getMethod(rendererMethod, SERVICE_METHOD_SIGNATURE);
                    serviceMethod.invoke(renderer, iRequest, iResponse);
                } else if (requestUri.getSelector().equals("res")) {
                    int len;
                    long ifModifiedSince;
                    isHtml = false;
                    long lastModified = this.startupTime;
                    if ("GET".equals(iRequest.getMethod()) && lastModified / 1000L <= (ifModifiedSince = iRequest.getDateHeader("If-Modified-Since")) / 1000L) {
                        iResponse.setStatus(304);
                        return;
                    }
                    String resourcePath = requestUri.getPath();
                    if (resourcePath == null) {
                        logger.error((Object)"Resource url does not contain any resource path.");
                        iResponse.sendError(404);
                        return;
                    }
                    URL authorization = this.getClass().getClassLoader().getResource(resourcePath + ".res");
                    if (authorization == null) {
                        logger.error((Object)("Requested resource '" + resourcePath + "' not authorized."));
                        iResponse.sendError(403);
                        return;
                    }
                    InputStream input = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
                    if (input == null) {
                        logger.error((Object)("Resource '" + resourcePath + "' not found."));
                        iResponse.sendError(404);
                        return;
                    }
                    String mimeType = iRequest.getParameter("mime-type");
                    if (mimeType == null) {
                        mimeType = iRequest.getSession().getServletContext().getMimeType(resourcePath);
                    }
                    if (mimeType == null) {
                        logger.warn((Object)("Unknown content type for resource '" + resourcePath + "'."));
                    } else {
                        iResponse.setContentType(mimeType);
                    }
                    long now = System.currentTimeMillis();
                    iResponse.setDateHeader("Last-Modified", lastModified);
                    iResponse.setDateHeader("Date", now);
                    iResponse.setDateHeader("Expires", now + EXPIRATION_DELAY);
                    ServletOutputStream output = iResponse.getOutputStream();
                    byte[] buffer = new byte[512];
                    while ((len = input.read(buffer)) >= 0) {
                        output.write(buffer, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                } else {
                    isHtml = false;
                }
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (isHtml) {
                    iRequest.setAttribute("javax.servlet.error.exception", (Object)t);
                    try {
                        iRequest.getRequestDispatcher("/" + requestUri.getServlet() + "/" + "page" + "/Error").forward((ServletRequest)iRequest, (ServletResponse)iResponse);
                    }
                    catch (ServletException e) {
                        logger.error((Object)"Error dispatching to error page:", (Throwable)e);
                    }
                    iRequest.removeAttribute("javax.servlet.error.exception");
                    break block43;
                }
                logger.error((Object)"Error:", t);
                iResponse.sendError(500);
            }
            finally {
                BricksSessionImpl.exitRequest();
            }
        }
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlnode_0_unb_GlobalBeans == null) {
            return null;
        }
        if (iName == null) {
            return null;
        }
        for (int i = 0; i < this._xmlnode_0_unb_GlobalBeans.length; ++i) {
            Type t = this._xmlnode_0_unb_GlobalBeans[i].getBeanGenericType(iName);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlnode_0_unb_GlobalBeans == null) {
            return null;
        }
        if (iName == null) {
            return null;
        }
        for (int i = 0; i < this._xmlnode_0_unb_GlobalBeans.length; ++i) {
            Class c = this._xmlnode_0_unb_GlobalBeans[i].getBeanType(iName);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this._xmlnode_0_unb_GlobalBeans == null) {
            return null;
        }
        if (iName == null) {
            return null;
        }
        for (int i = 0; i < this._xmlnode_0_unb_GlobalBeans.length; ++i) {
            Object o = this._xmlnode_0_unb_GlobalBeans[i].getBeanValue(iRequest, iName);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public String registerRequestHandler(String iUniqueId, Object iHandler) {
        if (this.getHandler(iUniqueId) != null) {
            this._id2Handler.put(iUniqueId, iHandler);
            this._handler2Id.put(iHandler, iUniqueId);
            return null;
        }
        int i = 1;
        while (this.getHandler(iUniqueId + i) != null) {
            ++i;
        }
        this._id2Handler.put(iUniqueId + i, iHandler);
        this._handler2Id.put(iHandler, iUniqueId + i);
        return iUniqueId + i;
    }

    private Object getHandler(String iId) {
        return this._id2Handler.get(iId);
    }

    private String getHandlerId(Object iHandler) {
        return this._handler2Id.get(iHandler);
    }

    public String getHandlerParamName() {
        return HANDLER_PARAMNAME;
    }

    public String getHandlerParamValue(Object iHandler, String iMethod) {
        String handlerId = this.getHandlerId(iHandler);
        return handlerId + "." + iMethod;
    }

    public UrlBuilder createHandlerUrl(HttpServletRequest iRequest, Object iHandler, String iMethod) {
        String handlerId = this.getHandlerId(iHandler);
        BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
        url.setParameter(HANDLER_PARAMNAME, handlerId + "." + iMethod);
        return url;
    }

    public UrlBuilder createServiceUrl(HttpServletRequest iRequest, Object iHandler, String iMethod) {
        String handlerId = this.getHandlerId(iHandler);
        BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, false);
        url.setSelector("srv");
        url.setPath(handlerId + "/" + iMethod);
        return url;
    }
}

