/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.action;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.enums.Severity;
import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.base.param.IUrlParameter;
import com.ebm_ws.infra.bricks.components.interfaces.IFrameContent;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Inform
implements IXmlObject,
IAction,
IIdentifiable,
IFrameContent {
    private Application _xmlroot;
    private String _xmlattr_opt_ID;
    private String _xmlattr_opt_FrameName;
    private Severity _xmlattr_opt_Severity = Severity.Info;
    private IUrlParameter[] _xmlnode_0_unb_AddParameters;
    private IMessage _xmlnode_req_Title;
    private IMessage _xmlnode_req_Message;
    private IAction _xmlnode_req_OnOk;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        if (this._xmlattr_opt_ID == null) {
            return "MsgBox";
        }
        return "MsgBox" + this._xmlattr_opt_ID;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlroot.registerRequestHandler(this.getPathID(), this) != null) {
            iErrors.logMessage((IXmlObject)this, "ID", 5, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        }
    }

    public String getURL(HttpServletRequest iRequest, boolean iEncodeHtml) throws Exception {
        UrlBuilder url = this._xmlroot.createHandlerUrl(iRequest, this, "invoke");
        if (this._xmlnode_0_unb_AddParameters != null) {
            for (int i = 0; i < this._xmlnode_0_unb_AddParameters.length; ++i) {
                url.setParameter(this._xmlnode_0_unb_AddParameters[i].getName(), String.valueOf(this._xmlnode_0_unb_AddParameters[i].getValue(iRequest)));
            }
        }
        return url.toUrl(iRequest.getCharacterEncoding(), iEncodeHtml);
    }

    public void invoke(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        if ("POST".equals(iRequest.getMethod())) {
            iResponse.sendRedirect(this.getURL(iRequest, false));
            return;
        }
        BricksSession session = BricksSession.getSession(iRequest);
        iRequest.setAttribute("_RENDER_PAGE_", (Object)this);
        IFrame frame = this._xmlroot.getFrame(this._xmlattr_opt_FrameName);
        frame.preRender(iRequest);
        iResponse.setContentType("text/html;charset=" + session.getLocaleConfig().getCharSet());
        iResponse.setHeader("Cache-Control", "no-cache");
        iResponse.setHeader("Pragma", "no-cache");
        iResponse.setDateHeader("Expires", 0L);
        PrintWriter htmlWriter = iResponse.getWriter();
        htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
        htmlWriter.print("<html lang=\"");
        htmlWriter.print(session.getLocaleConfig().getLocale().getLanguage());
        htmlWriter.println("\">");
        htmlWriter.println("<head>");
        htmlWriter.print("<title>");
        htmlWriter.print(HtmlUtils.encode2HTML(this._xmlnode_req_Title.getMessage(iRequest)));
        htmlWriter.println("</title>");
        htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset=" + session.getLocaleConfig().getCharSet() + "'>");
        htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
        htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
        htmlWriter.println("<meta http-equiv='expires' content='0'>");
        htmlWriter.print("<base href='");
        htmlWriter.print(iRequest.getScheme());
        htmlWriter.print("://");
        htmlWriter.print(iRequest.getServerName());
        htmlWriter.print(":");
        htmlWriter.print(String.valueOf(iRequest.getServerPort()));
        htmlWriter.print(iRequest.getContextPath());
        htmlWriter.print("/");
        htmlWriter.println("'>");
        CssStyleSheet[] styleSheets = frame.getStyleSheets();
        if (styleSheets != null) {
            for (int i = 0; i < styleSheets.length; ++i) {
                htmlWriter.print("<link rel='stylesheet' type='text/css' href='");
                htmlWriter.print(styleSheets[i].getFile());
                htmlWriter.println("'>");
            }
        }
        htmlWriter.println("</head>");
        htmlWriter.println("<body>");
        frame.render(iRequest, iResponse);
        htmlWriter.println("</body>");
        htmlWriter.println("</html>");
        htmlWriter.flush();
        htmlWriter.close();
    }

    public String getFrameName() {
        return this._xmlattr_opt_FrameName;
    }

    public String getTitle(HttpServletRequest request) throws Exception {
        return this._xmlnode_req_Title.getMessage(request);
    }

    public void servePage(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        this.invoke(iRequest, iResponse);
    }

    public void preRender(HttpServletRequest request) throws Exception {
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.println("<div id='messagebox' class='" + this._xmlattr_opt_Severity.getName() + "'>");
        iWriter.println("<p class='message'>");
        iWriter.println(HtmlUtils.encode2HTML(this._xmlnode_req_Message.getMessage(iRequest)));
        iWriter.println("</p>");
        iWriter.print("<div class='Buttons'>");
        iWriter.print("<ul>");
        String nextUrl = this._xmlnode_req_OnOk.getURL(iRequest, true);
        iWriter.print("<li>");
        iWriter.print("<a href='");
        iWriter.print(nextUrl);
        iWriter.print("'>");
        iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.continue")));
        iWriter.print("</a>");
        iWriter.println("</li>");
        iWriter.print("</ul>");
        iWriter.println("</div>");
        iWriter.println("</div>");
    }
}

