/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding;

import com.ebm_ws.infra.bricks.components.base.enums.Scope;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;

public class Bean
implements IXmlObject {
    private static Class[] DEFAULT_CONSTR = new Class[0];
    private String _xmlattr_req_Name;
    private Scope _xmlattr_req_LifeScope;
    private String _xmlattr_req_Class;
    private Class _class;
    private boolean initialized = false;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        try {
            this._class = Class.forName(this._xmlattr_req_Class);
        }
        catch (ClassNotFoundException e) {
            iErrors.logMessage((IXmlObject)this, "Class", 1, "Bean Class '" + this._xmlattr_req_Class + "' not found.");
        }
        if (this._class != null) {
            try {
                this._class.getConstructor(DEFAULT_CONSTR);
            }
            catch (Exception e) {
                iErrors.logMessage((IXmlObject)this, "Class", 3, "Bean Class '" + this._xmlattr_req_Class + "' has no default constructor. Won't be able to instanciate.");
            }
        }
    }

    public String getName() {
        return this._xmlattr_req_Name;
    }

    public Type getGenericType() throws IBeanProvider.UnresolvedBeanError {
        return this.getType();
    }

    public Class getType() throws IBeanProvider.UnresolvedBeanError {
        if (!this.initialized) {
            this.initialized = true;
            try {
                this._class = Class.forName(this._xmlattr_req_Class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this._class == null) {
            throw new IBeanProvider.UnresolvedBeanError();
        }
        return this._class;
    }

    public Object getObject(HttpServletRequest iRequest) throws Exception {
        BricksSession session;
        Object obj = null;
        if (this._xmlattr_req_LifeScope == Scope.Request) {
            obj = iRequest.getAttribute(this.getName());
        } else if (this._xmlattr_req_LifeScope == Scope.Session) {
            obj = iRequest.getSession().getAttribute(this.getName());
        } else if (this._xmlattr_req_LifeScope == Scope.Application) {
            obj = iRequest.getSession().getServletContext().getAttribute(this.getName());
        } else if (this._xmlattr_req_LifeScope == Scope.PageContext) {
            session = BricksSession.getSession(iRequest);
            obj = session.getCurrentPageContext().getAttribute(this.getName());
        }
        if (obj == null) {
            obj = this._class.newInstance();
            if (this._xmlattr_req_LifeScope == Scope.Request) {
                iRequest.setAttribute(this.getName(), obj);
            } else if (this._xmlattr_req_LifeScope == Scope.Session) {
                iRequest.getSession().setAttribute(this.getName(), obj);
            } else if (this._xmlattr_req_LifeScope == Scope.Application) {
                iRequest.getSession().getServletContext().setAttribute(this.getName(), obj);
            } else if (this._xmlattr_req_LifeScope == Scope.PageContext) {
                session = BricksSession.getSession(iRequest);
                session.getCurrentPageContext().setAttribute(this.getName(), obj);
            }
        }
        return obj;
    }
}

