/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ExpressionCompiler;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.ParseError;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class Expression
extends BaseBeanProvider
implements IXmlObject,
IBinding {
    private String _xmlcontent;
    private String _id;
    private IEvaluable _evaluable;
    private String _compilationError;

    private void initialize() {
        if (this._evaluable == null && this._compilationError == null) {
            this._xmlcontent = this._xmlcontent.trim();
            ExpressionCompiler compiler = new ExpressionCompiler(this._xmlcontent);
            try {
                this._evaluable = compiler.compile(new CompilationContext());
            }
            catch (ParseError e) {
                this._compilationError = e.getMessage();
            }
            catch (ICompilationContext.UnresolvedObjectError unresolvedObjectError) {
                // empty catch block
            }
        }
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        this.initialize();
        if (this._compilationError != null) {
            iErrors.logMessage((IXmlObject)this, "content", 1, this._compilationError);
        }
    }

    public Type getGenericType() {
        this.initialize();
        if (this._evaluable == null) {
            return null;
        }
        return this._evaluable.getGenericType();
    }

    public Class getType() {
        this.initialize();
        if (this._evaluable == null) {
            return null;
        }
        return this._evaluable.getType();
    }

    public boolean hasErrors() {
        this.initialize();
        return this._compilationError != null;
    }

    public Object invoke(HttpServletRequest iRequest) throws Exception {
        return this._evaluable.evaluate(new ExecutionContext(iRequest));
    }

    public String getID() {
        if (this._id == null) {
            this._id = HtmlUtils.formatId(this._xmlcontent);
        }
        return this._id;
    }

    public boolean isGetSet() {
        return this._evaluable.isGetSet();
    }

    public void setValue(HttpServletRequest iRequest, Object iValue) throws Exception {
        this._evaluable.set(new ExecutionContext(iRequest), iValue);
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if ("request".equals(iName)) {
            return HttpServletRequest.class;
        }
        if ("locale".equals(iName)) {
            return Locale.class;
        }
        return this.getParentBeanType(iName);
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if ("request".equals(iName)) {
            return HttpServletRequest.class;
        }
        if ("locale".equals(iName)) {
            return Locale.class;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if ("request".equals(iName)) {
            return iRequest;
        }
        if ("locale".equals(iName)) {
            return BricksSession.getSession(iRequest).getLocale();
        }
        return this.getParentBeanValue(iRequest, iName);
    }

    public String toString() {
        return "Expression(" + this._xmlcontent + ")";
    }

    private class ExecutionContext
    implements IExecutionContext {
        private HttpServletRequest request;

        public ExecutionContext(HttpServletRequest iRequest) {
            this.request = iRequest;
        }

        public Object getObject(String iName) throws Exception {
            return Expression.this.getBeanValue(this.request, iName);
        }
    }

    private class CompilationContext
    implements ICompilationContext {
        private CompilationContext() {
        }

        public Type getObjectGenericType(String iName) throws ICompilationContext.UnresolvedObjectError {
            try {
                return Expression.this.getBeanGenericType(iName);
            }
            catch (IBeanProvider.UnresolvedBeanError e) {
                throw new ICompilationContext.UnresolvedObjectError();
            }
        }

        public Class getObjectType(String iName) throws ICompilationContext.UnresolvedObjectError {
            try {
                return Expression.this.getBeanType(iName);
            }
            catch (IBeanProvider.UnresolvedBeanError e) {
                throw new ICompilationContext.UnresolvedObjectError();
            }
        }
    }
}

