/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.ArrayObj;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.Attribute;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.Braces;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.GlobalVar;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.Method;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.ParseError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.ParseHelper;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.StaticObj;
import java.io.StringReader;
import java.util.ArrayList;

public class ExpressionCompiler {
    private static IEvaluable[] EVAL_ARRAY_TYPE = new IEvaluable[0];
    private static String BLANK_CHARS = " \t\n\r";
    private static String SEPARATOR_CHARS = "'\".,;(){}[]=+-*&|/#<>";
    private ParseHelper parser;

    public ExpressionCompiler(String expression) {
        this.parser = new ParseHelper(new StringReader(expression));
    }

    public IEvaluable compile(ICompilationContext iContext) throws ParseError, ICompilationContext.UnresolvedObjectError {
        this.parser.curChar();
        try {
            return this.parseLeadingExpression(iContext, null);
        }
        catch (CompilationError e) {
            this.parser.rethrow("Compilation error", e);
            return null;
        }
    }

    private IEvaluable parseLeadingExpression(ICompilationContext iContext, String iExitOn) throws ParseError, CompilationError, ICompilationContext.UnresolvedObjectError {
        this.parser.skipChars(BLANK_CHARS);
        IEvaluable leadingExpression = null;
        if (this.parser.consumeChar('\'', null)) {
            String string = this.parser.readUntil("'");
            if (!this.parser.consumeChar('\'', null)) {
                this.parser.error(ParseError.RC_SYNTAX_ERROR, "Closing ' expected.");
            }
            leadingExpression = new StaticObj(iContext, string);
        } else if (this.parser.consumeChar('\"', null)) {
            String string = this.parser.readUntil("\"");
            if (!this.parser.consumeChar('\"', null)) {
                this.parser.error(ParseError.RC_SYNTAX_ERROR, "Closing \" expected.");
            }
            leadingExpression = new StaticObj(iContext, string);
        } else if (this.parser.consumeChar('[', null)) {
            ArrayList<IEvaluable> elts = new ArrayList<IEvaluable>();
            while (!this.parser.consumeChar(']', BLANK_CHARS)) {
                if (elts.size() > 0 && !this.parser.consumeChar(',', BLANK_CHARS)) {
                    this.parser.error(ParseError.RC_SYNTAX_ERROR, "',' expected");
                }
                this.parser.skipChars(BLANK_CHARS);
                IEvaluable elt = this.parseLeadingExpression(iContext, ",]");
                elts.add(elt);
            }
            leadingExpression = new ArrayObj(iContext, elts.toArray(EVAL_ARRAY_TYPE));
        } else {
            String word = this.parser.readUntil(BLANK_CHARS + SEPARATOR_CHARS);
            if (word == null || word.length() == 0) {
                this.parser.error(ParseError.RC_SYNTAX_ERROR, "Expression expected.");
            }
            if (word.equals("true")) {
                leadingExpression = new StaticObj(iContext, Boolean.TRUE);
            } else if (word.equals("false")) {
                leadingExpression = new StaticObj(iContext, Boolean.FALSE);
            } else {
                try {
                    Integer val = new Integer(word);
                    leadingExpression = new StaticObj(iContext, val);
                }
                catch (NumberFormatException e) {
                    leadingExpression = new GlobalVar(iContext, word);
                }
            }
        }
        return this.parseObjectExpression(iContext, leadingExpression, iExitOn);
    }

    private IEvaluable parseObjectExpression(ICompilationContext iContext, IEvaluable iObject, String iExitOn) throws ParseError, CompilationError, ICompilationContext.UnresolvedObjectError {
        if (this.parser.curChar() < 0 || iExitOn != null && iExitOn.indexOf(this.parser.curChar()) >= 0) {
            return iObject;
        }
        if (this.parser.consumeChar('.', null)) {
            String name = this.parser.readUntil(BLANK_CHARS + SEPARATOR_CHARS);
            if (name == null || name.length() == 0) {
                this.parser.error(ParseError.RC_SYNTAX_ERROR, "Attribute or method name expected.");
            }
            if (this.parser.consumeChar('(', BLANK_CHARS)) {
                ArrayList<IEvaluable> arguments = new ArrayList<IEvaluable>();
                while (!this.parser.consumeChar(')', BLANK_CHARS)) {
                    if (arguments.size() > 0 && !this.parser.consumeChar(',', BLANK_CHARS)) {
                        this.parser.error(ParseError.RC_SYNTAX_ERROR, "',' expected");
                    }
                    this.parser.skipChars(BLANK_CHARS);
                    IEvaluable arg = this.parseLeadingExpression(iContext, ",)");
                    arguments.add(arg);
                }
                return this.parseObjectExpression(iContext, new Method(iContext, name, iObject, arguments.toArray(EVAL_ARRAY_TYPE)), iExitOn);
            }
            return this.parseObjectExpression(iContext, new Attribute(iContext, name, iObject), iExitOn);
        }
        if (this.parser.consumeChar('[', null)) {
            Braces braces = new Braces(iContext, iObject, this.parseLeadingExpression(iContext, "]"));
            if (!this.parser.consumeChar(']', null)) {
                this.parser.error(ParseError.RC_SYNTAX_ERROR, "Closing brace ']' expected.");
            }
            return this.parseObjectExpression(iContext, braces, iExitOn);
        }
        this.parser.error(ParseError.RC_SYNTAX_ERROR, "Unexpected char: '" + (char)this.parser.curChar() + "'.");
        return null;
    }
}

