/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

public class ArrayObj
implements IEvaluable {
    private IEvaluable[] elements;
    private Class arrayCompType;
    private Object arrayPrototype;

    public ArrayObj(ICompilationContext iContext, IEvaluable[] iElements) throws CompilationError {
        this.elements = iElements;
        this.arrayCompType = Object.class;
        if (iElements != null && iElements.length > 0) {
            this.arrayCompType = iElements[0].getType();
            for (int i = 1; i < iElements.length; ++i) {
                while (!iElements[i].getType().isAssignableFrom(this.arrayCompType)) {
                    this.arrayCompType = this.arrayCompType.getSuperclass();
                    if (this.arrayCompType != Object.class) continue;
                }
            }
        }
        this.arrayPrototype = Array.newInstance(this.arrayCompType, 0);
    }

    public Object evaluate(IExecutionContext iContext) throws Exception {
        Object array = Array.newInstance(this.arrayCompType, this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            Array.set(array, i, this.elements[i].evaluate(iContext));
        }
        return array;
    }

    public Class getType() {
        return this.arrayPrototype.getClass();
    }

    public Type getGenericType() {
        return this.arrayPrototype.getClass();
    }

    public void set(IExecutionContext iContext, Object iValue) throws Exception {
    }

    public boolean isGetSet() {
        return false;
    }

    public String getExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.elements[i].getExpression());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return "Expression: " + this.getExpression();
    }
}

