/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class Attribute
implements IEvaluable {
    private static Object[] NO_ARG = new Object[0];
    private static Class[] GET_SIGNATURE = new Class[0];
    private IEvaluable object;
    private String attrName;
    private Method get;
    private Method set;

    public Attribute(ICompilationContext iContext, String iName, IEvaluable iObject) throws CompilationError {
        this.object = iObject;
        this.attrName = iName;
        Class objType = iObject.getType();
        String getMethodName = "get" + Character.toUpperCase(this.attrName.charAt(0)) + this.attrName.substring(1);
        try {
            this.get = objType.getMethod(getMethodName, GET_SIGNATURE);
        }
        catch (Exception e) {
            String isMethodName = "is" + Character.toUpperCase(this.attrName.charAt(0)) + this.attrName.substring(1);
            try {
                this.get = objType.getMethod(isMethodName, GET_SIGNATURE);
                if (this.get.getReturnType() != Boolean.class && this.get.getReturnType() != Boolean.TYPE) {
                    throw new CompilationError("The 'is' getter signature is only allowed for boolean type attributes.");
                }
            }
            catch (Exception e1) {
                throw new CompilationError("No such attribute: '" + this.attrName + "' (neither " + getMethodName + " nor " + isMethodName + " on object " + objType.getName() + ").", e);
            }
        }
        if ((this.get.getModifiers() & 1) == 0) {
            throw new CompilationError("Get method not public: " + this.get);
        }
        String setMethodName = "set" + Character.toUpperCase(this.attrName.charAt(0)) + this.attrName.substring(1);
        try {
            this.set = objType.getMethod(setMethodName, this.get.getReturnType());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.set != null && (this.set.getModifiers() & 1) == 0) {
            this.set = null;
        }
    }

    public Object evaluate(IExecutionContext iContext) throws Exception {
        Object obj = this.object.evaluate(iContext);
        try {
            return this.get.invoke(obj, NO_ARG);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            throw new Exception("Error while getting Attribute: " + this.getExpression(), e);
        }
    }

    public Type getGenericType() {
        return this.get.getGenericReturnType();
    }

    public Class getType() {
        return this.get.getReturnType();
    }

    public boolean isGetSet() {
        return this.set != null;
    }

    public void set(IExecutionContext iContext, Object iValue) throws Exception {
        if (this.set == null) {
            return;
        }
        Object obj = this.object.evaluate(iContext);
        try {
            if (iValue == null && this.get.getReturnType().isPrimitive()) {
                if (this.get.getReturnType() == Integer.TYPE) {
                    iValue = 0;
                } else if (this.get.getReturnType() == Short.TYPE) {
                    iValue = 0;
                } else if (this.get.getReturnType() == Long.TYPE) {
                    iValue = 0;
                } else if (this.get.getReturnType() == Boolean.TYPE) {
                    iValue = true;
                }
            }
            this.set.invoke(obj, iValue);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            throw new Exception("Error while setting Attribute: " + this.getExpression(), e);
        }
    }

    public String getExpression() {
        return this.object.getExpression() + "." + this.attrName;
    }

    public String toString() {
        return "Expression: " + this.getExpression();
    }
}

