/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class Braces
implements IEvaluable {
    private IEvaluable object;
    private IEvaluable item;
    private Class returnClass;
    private Type returnType;

    public Braces(ICompilationContext iContext, IEvaluable iObject, IEvaluable iItem) throws CompilationError {
        this.object = iObject;
        this.item = iItem;
        Type objType = iObject.getGenericType();
        Class objClass = iObject.getType();
        Class itemClass = this.item.getType();
        if (objClass.isArray()) {
            if (!Integer.class.isAssignableFrom(itemClass) && !Integer.TYPE.isAssignableFrom(itemClass)) {
                throw new CompilationError("Brace argument must be either int or Integer.");
            }
            this.returnClass = objClass.getComponentType();
            this.returnType = this.returnClass;
            if (objType instanceof GenericArrayType) {
                this.returnType = ((GenericArrayType)objType).getGenericComponentType();
            }
        } else if (List.class.isAssignableFrom(objClass)) {
            if (!Integer.class.isAssignableFrom(itemClass) && !Integer.TYPE.isAssignableFrom(itemClass)) {
                throw new CompilationError("Brace argument must be either int or Integer.");
            }
            this.returnType = Object.class;
            this.returnClass = Object.class;
            if (objType instanceof ParameterizedType) {
                this.returnType = ((ParameterizedType)objType).getActualTypeArguments()[0];
                if (this.returnType instanceof Class) {
                    this.returnClass = (Class)this.returnType;
                } else if (this.returnType instanceof ParameterizedType) {
                    this.returnClass = (Class)((ParameterizedType)this.returnType).getRawType();
                }
            }
        } else if (Map.class.isAssignableFrom(objClass)) {
            this.returnType = Object.class;
            this.returnClass = Object.class;
            if (objType instanceof ParameterizedType) {
                this.returnType = ((ParameterizedType)objType).getActualTypeArguments()[1];
                Class declaredItemClass = null;
                Type declaredItemType = ((ParameterizedType)objType).getActualTypeArguments()[0];
                if (declaredItemType instanceof Class) {
                    declaredItemClass = (Class)declaredItemType;
                } else if (declaredItemType instanceof ParameterizedType) {
                    declaredItemClass = (Class)((ParameterizedType)declaredItemType).getRawType();
                }
                if (declaredItemClass != null && !declaredItemClass.isAssignableFrom(itemClass)) {
                    throw new CompilationError("Brace argument must be of type " + declaredItemClass.getName() + ".");
                }
                if (this.returnType instanceof Class) {
                    this.returnClass = (Class)this.returnType;
                } else if (this.returnType instanceof ParameterizedType) {
                    this.returnClass = (Class)((ParameterizedType)this.returnType).getRawType();
                }
            }
        } else {
            throw new CompilationError("Object type does not support [] access: " + objClass.getName());
        }
    }

    public Object evaluate(IExecutionContext iContext) throws Exception {
        Object obj = this.object.evaluate(iContext);
        Object arg = this.item.evaluate(iContext);
        if (obj.getClass().isArray()) {
            int index = 0;
            if (arg instanceof Integer) {
                index = (Integer)arg;
            } else if (arg instanceof Long) {
                index = ((Long)arg).intValue();
            } else {
                throw new Exception("Argument not an int: " + arg);
            }
            return Array.get(obj, index);
        }
        if (obj instanceof List) {
            int index = 0;
            if (arg instanceof Integer) {
                index = (Integer)arg;
            } else if (arg instanceof Long) {
                index = ((Long)arg).intValue();
            } else {
                throw new Exception("Argument not an int: " + arg);
            }
            return ((List)obj).get(index);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(this.item);
        }
        throw new Exception("Object type does not support []: " + this.object.getClass().getName());
    }

    public Class getType() {
        return this.returnClass;
    }

    public Type getGenericType() {
        return this.returnType;
    }

    public void set(IExecutionContext iContext, Object iValue) throws Exception {
    }

    public boolean isGetSet() {
        return false;
    }

    public String getExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.object.getExpression());
        sb.append("[");
        sb.append(this.item.getExpression());
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return "Expression: " + this.getExpression();
    }
}

