/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import java.lang.reflect.Type;

public class GlobalVar
implements IEvaluable {
    private String varName;
    private Class varClass;
    private Type varType;

    public GlobalVar(ICompilationContext iContext, String iName) throws CompilationError, ICompilationContext.UnresolvedObjectError {
        this.varName = iName;
        this.varClass = iContext.getObjectType(this.varName);
        this.varType = iContext.getObjectGenericType(this.varName);
        if (this.varType == null) {
            throw new CompilationError("No such object: '" + this.varName + "'.");
        }
    }

    public Object evaluate(IExecutionContext iContext) throws Exception {
        try {
            return iContext.getObject(this.varName);
        }
        catch (Exception e) {
            throw new Exception("Error while retrieving GlobalVar: " + this.getExpression(), e);
        }
    }

    public Class getType() {
        return this.varClass;
    }

    public Type getGenericType() {
        return this.varType;
    }

    public void set(IExecutionContext iContext, Object iValue) throws Exception {
    }

    public boolean isGetSet() {
        return false;
    }

    public String getExpression() {
        return this.varName;
    }

    public String toString() {
        return "Expression: " + this.getExpression();
    }
}

