/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.CompilationError;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.ICompilationContext;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IEvaluable;
import com.ebm_ws.infra.bricks.components.base.binding.expressions.IExecutionContext;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public class Method
implements IEvaluable {
    private IEvaluable object;
    private IEvaluable[] arguments;
    private String methodName;
    private java.lang.reflect.Method method;

    public Method(ICompilationContext iContext, String iName, IEvaluable iObject, IEvaluable[] iArgs) throws CompilationError {
        int i;
        this.object = iObject;
        this.arguments = iArgs;
        this.methodName = iName;
        Class objType = iObject.getType();
        Class[] argTypes = new Class[this.arguments.length];
        for (int i2 = 0; i2 < this.arguments.length; ++i2) {
            argTypes[i2] = this.arguments[i2].getType();
        }
        try {
            this.method = objType.getMethod(this.methodName, argTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.method == null) {
            java.lang.reflect.Method[] methods = objType.getMethods();
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(iName) || methods[i].getParameterTypes().length != argTypes.length) continue;
                this.method = methods[i];
                for (int j = 0; j < argTypes.length; ++j) {
                    Class<?> paramClass = methods[i].getParameterTypes()[j];
                    if (ReflectionHelper.isAssignable(paramClass, argTypes[j])) continue;
                    this.method = null;
                    break;
                }
                if (this.method != null) break;
            }
        }
        if (this.method == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("No such method: ");
            sb.append(objType.getName());
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            for (i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argTypes[i].getName());
            }
            sb.append(")");
            throw new CompilationError(sb.toString());
        }
        if ((this.method.getModifiers() & 1) == 0) {
            throw new CompilationError("Method not public: " + this.method);
        }
    }

    public Object evaluate(IExecutionContext iContext) throws Exception {
        Object obj = this.object.evaluate(iContext);
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            args[i] = this.arguments[i].evaluate(iContext);
        }
        try {
            return this.method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            throw new Exception("Error while invoking Method: " + this.getExpression(), e);
        }
    }

    public Type getGenericType() {
        return this.method.getGenericReturnType();
    }

    public Class getType() {
        return this.method.getReturnType();
    }

    public void set(IExecutionContext iContext, Object iValue) throws Exception {
    }

    public boolean isGetSet() {
        return false;
    }

    public String getExpression() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.object.getExpression());
        sb.append(".");
        sb.append(this.methodName);
        sb.append("(");
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.arguments[i].getExpression());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return "Expression: " + this.getExpression();
    }
}

