/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ParseError
extends Exception {
    public static int RC_OK = 0;
    public static int RC_INTERNAL_ERROR = 100;
    public static int RC_SYNTAX_ERROR = 101;
    public static int RC_FUNCTION_NOT_FOUND = 102;
    public static int RC_TYPE_NOT_FOUND_ERROR = 103;
    public static int RC_APPLICATION_ERROR = 200;
    private int _code;
    private int _lineNb;
    private int _colNb;
    private Throwable _ex;
    private String _curLine;

    public ParseError(Throwable exception, String message, int lineNb, int colNb, String curLine) {
        super(message);
        this._ex = exception;
        this._lineNb = lineNb;
        this._colNb = colNb;
        this._curLine = curLine;
        this._code = RC_APPLICATION_ERROR;
    }

    public ParseError(int code, String message, int lineNb, int colNb, String curLine) {
        super(message);
        this._code = code;
        this._lineNb = lineNb;
        this._colNb = colNb;
        this._curLine = curLine;
    }

    public Throwable getWrappedException() {
        return this._ex;
    }

    public String getShortMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        if (this._ex != null) {
            return super.getMessage() + " at line " + this._lineNb + ":\nWrapping: " + this._ex.getMessage() + "\n" + this._curLine + "\n" + this.getCurCharArrow();
        }
        return super.getMessage() + " at line " + this._lineNb + ":\n" + this._curLine + "\n" + this.getCurCharArrow();
    }

    public void printStackTrace() {
        if (this._ex != null) {
            this._ex.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream iStream) {
        if (this._ex != null) {
            this._ex.printStackTrace(iStream);
        } else {
            super.printStackTrace(iStream);
        }
    }

    public void printStackTrace(PrintWriter iWriter) {
        if (this._ex != null) {
            this._ex.printStackTrace(iWriter);
        } else {
            super.printStackTrace(iWriter);
        }
    }

    public int getCode() {
        return this._code;
    }

    public int getLine() {
        return this._lineNb;
    }

    public int getColumn() {
        return this._colNb;
    }

    public String getScriptLine() {
        return this._curLine;
    }

    public String getCurCharArrow() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._colNb - 1; ++i) {
            sb.append('-');
        }
        sb.append('^');
        return sb.toString();
    }
}

