/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.binding.expressions.impl;

import com.ebm_ws.infra.bricks.components.base.binding.expressions.impl.ParseError;
import java.io.Reader;

public class ParseHelper {
    private String NEWLINE_CHARSET = "\n\r";
    private String OPENING_COMMENT_BLOCK = null;
    private String CLOSING_COMMENT_BLOCK = null;
    private Reader _input;
    private StringBuffer _curLine;
    private int curChar = Integer.MIN_VALUE;
    private int[] forseeBuffer = new int[1];
    private int availableInForesee = 0;
    private int lineNb = 1;
    private int colNb = 0;
    private StringBuffer _buffer;

    public ParseHelper(Reader iInput) {
        this._input = iInput;
        this._buffer = new StringBuffer();
        this._curLine = new StringBuffer();
    }

    public void setCommentBlockTags(String iOpening, String iClosing) {
        this.OPENING_COMMENT_BLOCK = iOpening;
        this.CLOSING_COMMENT_BLOCK = iClosing;
    }

    public int curChar() throws ParseError {
        if (this.curChar == Integer.MIN_VALUE) {
            this.nextChar();
        }
        return this.curChar;
    }

    public int foreseeChar(int iNbChars) throws ParseError {
        if (iNbChars == 0) {
            return this.curChar;
        }
        if (iNbChars > this.forseeBuffer.length) {
            int[] buff = this.forseeBuffer;
            this.forseeBuffer = new int[iNbChars * 2];
            System.arraycopy(buff, 0, this.forseeBuffer, 0, buff.length);
        }
        while (this.availableInForesee < iNbChars) {
            try {
                this.forseeBuffer[this.availableInForesee++] = this._input.read();
            }
            catch (Exception e) {
                this.rethrow("IO Exception", e);
            }
        }
        return this.forseeBuffer[iNbChars - 1];
    }

    private int doReadNextChar() throws ParseError {
        if (this.availableInForesee > 0) {
            this.curChar = this.forseeBuffer[0];
            --this.availableInForesee;
            for (int i = 0; i < this.availableInForesee; ++i) {
                this.forseeBuffer[i] = this.forseeBuffer[i + 1];
            }
        } else {
            try {
                this.curChar = this._input.read();
            }
            catch (Exception e) {
                this.rethrow("IO Exception", e);
            }
        }
        if (this.curChar == 10) {
            ++this.lineNb;
            this.colNb = 0;
        } else if (this.curChar != 13) {
            if (this.colNb == 0) {
                this._curLine.setLength(0);
            }
            this._curLine.append((char)this.curChar);
            ++this.colNb;
        }
        return this.curChar;
    }

    public int nextChar() throws ParseError {
        this.doReadNextChar();
        if (this.OPENING_COMMENT_BLOCK != null && this.CLOSING_COMMENT_BLOCK != null) {
            int i;
            boolean isOpeningComment = true;
            for (i = 0; i < this.OPENING_COMMENT_BLOCK.length(); ++i) {
                if (this.foreseeChar(i) == this.OPENING_COMMENT_BLOCK.charAt(i)) continue;
                isOpeningComment = false;
                break;
            }
            if (isOpeningComment) {
                for (i = 0; i < this.OPENING_COMMENT_BLOCK.length(); ++i) {
                    this.doReadNextChar();
                }
                StringBuffer comment = new StringBuffer();
                while (this.curChar >= 0) {
                    int i2;
                    boolean isClosingComment = true;
                    for (i2 = 0; i2 < this.CLOSING_COMMENT_BLOCK.length(); ++i2) {
                        if (this.foreseeChar(i2) == this.CLOSING_COMMENT_BLOCK.charAt(i2)) continue;
                        isClosingComment = false;
                        break;
                    }
                    if (isClosingComment) {
                        for (i2 = 0; i2 < this.CLOSING_COMMENT_BLOCK.length(); ++i2) {
                            this.doReadNextChar();
                        }
                        this.curChar = 32;
                        break;
                    }
                    comment.append((char)this.doReadNextChar());
                }
            }
        }
        return this.curChar;
    }

    public boolean consumeChar(char c, String skip) throws ParseError {
        if (skip != null) {
            this.skipChars(skip);
        }
        if (this.curChar != c) {
            return false;
        }
        this.nextChar();
        return true;
    }

    public void skipChars(String chars) throws ParseError {
        while (this.curChar >= 0 && chars.indexOf(this.curChar) >= 0) {
            this.nextChar();
        }
    }

    public String readUntil(String chars) throws ParseError {
        this._buffer.setLength(0);
        while (this.curChar >= 0 && chars.indexOf(this.curChar) < 0) {
            this._buffer.append((char)this.curChar);
            this.nextChar();
        }
        if (this._buffer.length() == 0) {
            return null;
        }
        return this._buffer.toString();
    }

    public boolean consumeString(String iChars) throws ParseError {
        int i;
        boolean matches = true;
        this.foreseeChar(iChars.length());
        for (i = 0; i < iChars.length(); ++i) {
            if (this.foreseeChar(i) == iChars.charAt(i)) continue;
            matches = false;
            break;
        }
        if (matches) {
            for (i = 0; i < iChars.length(); ++i) {
                this.consumeChar(iChars.charAt(i), null);
            }
        }
        return matches;
    }

    public String readUntilString(String iChars) throws ParseError {
        StringBuffer str = new StringBuffer();
        while (true) {
            this.foreseeChar(iChars.length());
            for (int i = 0; i < iChars.length() && this.foreseeChar(i) == iChars.charAt(i); ++i) {
            }
            if (this.consumeString(iChars)) {
                return str.toString();
            }
            str.append((char)this.curChar());
            this.nextChar();
        }
    }

    public void rethrow(String message, Throwable th) throws ParseError {
        int l = this.lineNb;
        int c = this.colNb;
        this.readUntil(this.NEWLINE_CHARSET);
        throw new ParseError(th, message, l, c, this._curLine.toString());
    }

    public void error(int type, String message) throws ParseError {
        int l = this.lineNb;
        int c = this.colNb;
        this.readUntil(this.NEWLINE_CHARSET);
        throw new ParseError(type, message, l, c, this._curLine.toString());
    }
}

