/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.error;

import com.ebm_ws.infra.bricks.components.base.error.ErrorHandler;
import com.ebm_ws.infra.bricks.error.IError;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultErrorHandler
extends ErrorHandler {
    public String getTitle(HttpServletRequest iRequest) throws Exception {
        BricksSession session = BricksSession.getSession(iRequest);
        return this.getLocalizedErrorTitle(DefaultErrorHandler.getError(iRequest), session.getLocale(), iRequest);
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        Throwable error = DefaultErrorHandler.getError(iRequest);
        short type = this.getErrorType(error, iRequest);
        if (type == 1) {
            logger.warn((Object)"Technical Error Occured", error);
        }
    }

    public short getErrorType(Throwable iError, HttpServletRequest iRequest) {
        if (iError instanceof IError) {
            return ((IError)iError).getType();
        }
        return 1;
    }

    public String getLocalizedErrorTitle(Throwable iError, Locale iLocale, HttpServletRequest iRequest) {
        if (iError instanceof IError) {
            IError de = (IError)iError;
            return de.getTitle(iRequest);
        }
        Object[] args = new Object[]{iError.getMessage(), iError.getClass().getName(), iError.getClass().getSimpleName()};
        ResourceBundle msgs = BricksMessages.getBundle(iLocale);
        return MessageFormat.format(msgs.getString("error.generic.title"), args);
    }

    public String getLocalizedErrorMessage(Throwable iError, Locale iLocale, HttpServletRequest iRequest) {
        if (iError instanceof IError) {
            IError de = (IError)iError;
            return de.getMessage(iRequest);
        }
        ResourceBundle msgs = BricksMessages.getBundle(iLocale);
        Object[] args = new Object[]{iError.getMessage(), iError.getClass().getName(), iError.getClass().getSimpleName()};
        return MessageFormat.format(msgs.getString("error.generic.message"), args);
    }

    public String getNextUrl(Throwable iError, HttpServletRequest iRequest) {
        IError de;
        String forcedUrl = DefaultErrorHandler.getNextUrl(iRequest);
        if (forcedUrl != null) {
            return forcedUrl;
        }
        if (iError instanceof IError && (de = (IError)iError).getNextUrl() != null) {
            return de.getNextUrl();
        }
        String referrerUrl = iRequest.getHeader("referer");
        if (referrerUrl != null) {
            return referrerUrl;
        }
        BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, false);
        return url.getServlet();
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        Throwable error = DefaultErrorHandler.getError(iRequest);
        String nextUrl = this.getNextUrl(error, iRequest);
        short type = this.getErrorType(error, iRequest);
        String message = this.getLocalizedErrorMessage(error, iResponse.getLocale(), iRequest);
        writer.println("<div id='errorbox'>");
        writer.println("<p class='message'>");
        if (type == 0) {
            writer.print(HtmlUtils.encode2HTML(message));
        } else {
            ResourceBundle msgs = BricksMessages.getBundle(iResponse.getLocale());
            String cause = error.getCause() == null ? null : this.getLocalizedErrorMessage(error.getCause(), iResponse.getLocale(), iRequest);
            writer.println("<dl>");
            writer.print("<dt>");
            writer.print("<strong>");
            writer.print(msgs.getString("error.message.label"));
            writer.print("</strong>");
            writer.println("</dt>");
            writer.print("<dd>");
            writer.print(HtmlUtils.encode2HTML(message));
            writer.println("</dd>");
            if (cause != null) {
                writer.print("<dt>");
                writer.print("<strong>");
                writer.print(msgs.getString("error.cause.label"));
                writer.print("</strong>");
                writer.println("</dt>");
                writer.print("<dd>");
                writer.print(HtmlUtils.encode2HTML(cause));
                writer.println("</dd>");
            }
            writer.println("</dl>");
        }
        writer.println("</p>");
        writer.print("<div class='Buttons'>");
        writer.print("<ul>");
        if (error != null && type != 0) {
            writer.print("<li>");
            writer.print("<a href=\"javascript:void(stack.style.display=stack.style.display == 'none' ? 'block' : 'none')\">");
            writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "error.show_stack")));
            writer.print("</a>");
            writer.println("</li>");
        }
        writer.print("<li>");
        writer.print("<a href='");
        writer.print(nextUrl);
        writer.print("'>");
        writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "error.ok")));
        writer.print("</a>");
        writer.println("</li>");
        writer.print("</ul>");
        writer.println("</div>");
        if (error != null && type != 0) {
            writer.println("<div id='stack' style=\"display: none\">");
            writer.println("<dl>");
            for (int i = 0; i < 10 && error != null; error = error.getCause(), ++i) {
                if (error instanceof InvocationTargetException) {
                    error = ((InvocationTargetException)error).getTargetException();
                }
                writer.print("<dt>");
                writer.print("<strong>");
                writer.print(error.getClass().getName());
                writer.print(": ");
                writer.print(HtmlUtils.encode2HTML(error.getMessage()));
                writer.print("</strong>");
                writer.println("</dt>");
                writer.print("<dd>");
                writer.print("<pre>");
                StackTraceElement[] elements = error.getStackTrace();
                for (int j = 0; j < elements.length; ++j) {
                    writer.println(HtmlUtils.encode2HTML(elements[j].toString()));
                }
                writer.print("</pre>");
                writer.println("</dd>");
            }
            writer.println("</dl>");
            writer.println("</div>");
        }
        writer.println("</div>");
    }
}

