/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.error;

import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.interfaces.IFrameContent;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ErrorHandler
implements IFrameContent,
IXmlObject {
    protected static Log logger = LogFactory.getLog(ErrorHandler.class);
    protected String _xmlattr_opt_FrameName;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    public String getFrameName() {
        return this._xmlattr_opt_FrameName;
    }

    public static void setNextUrl(HttpServletRequest iRequest, String nextUrl) {
        iRequest.setAttribute("javax.servlet.error.next_url", (Object)nextUrl);
    }

    public static String getNextUrl(HttpServletRequest iRequest) {
        return (String)iRequest.getAttribute("javax.servlet.error.next_url");
    }

    public static Throwable getError(HttpServletRequest iRequest) {
        return (Throwable)iRequest.getAttribute("javax.servlet.error.exception");
    }

    public abstract String getTitle(HttpServletRequest var1) throws Exception;

    public void servePage(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        BricksSession session = BricksSession.getSession(iRequest);
        try {
            iRequest.setAttribute("_RENDER_PAGE_", (Object)this);
            session.getApplication().getFrame(this.getFrameName()).preRender(iRequest);
            iResponse.setContentType("text/html;charset=" + session.getLocaleConfig().getCharSet());
            iResponse.setHeader("Cache-Control", "no-cache");
            iResponse.setHeader("Pragma", "no-cache");
            iResponse.setDateHeader("Expires", 0L);
            PrintWriter htmlWriter = iResponse.getWriter();
            htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
            htmlWriter.print("<html lang=\"");
            htmlWriter.print(session.getLocaleConfig().getLocale().getLanguage());
            htmlWriter.println("\">");
            htmlWriter.println("<head>");
            htmlWriter.print("<title>");
            htmlWriter.print(HtmlUtils.encode2HTML(this.getTitle(iRequest)));
            htmlWriter.println("</title>");
            htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset=" + session.getLocaleConfig().getCharSet() + "'>");
            htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
            htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
            htmlWriter.println("<meta http-equiv='expires' content='0'>");
            htmlWriter.print("<base href='");
            htmlWriter.print(iRequest.getScheme());
            htmlWriter.print("://");
            htmlWriter.print(iRequest.getServerName());
            htmlWriter.print(":");
            htmlWriter.print(String.valueOf(iRequest.getServerPort()));
            htmlWriter.print(iRequest.getContextPath());
            htmlWriter.print("/");
            htmlWriter.println("'>");
            IFrame frame = session.getApplication().getFrame(this.getFrameName());
            CssStyleSheet[] styleSheets = frame.getStyleSheets();
            if (styleSheets != null) {
                for (int i = 0; i < styleSheets.length; ++i) {
                    htmlWriter.print("<link rel='stylesheet' type='text/css' href='");
                    htmlWriter.print(styleSheets[i].getFile());
                    htmlWriter.println("'>");
                }
            }
            htmlWriter.println("</head>");
            htmlWriter.println("<body>");
            frame.render(iRequest, iResponse);
            htmlWriter.println("</body>");
            htmlWriter.println("</html>");
            htmlWriter.flush();
            htmlWriter.close();
        }
        catch (Throwable t) {
            logger.error((Object)"Error while rendering error page:", t);
            iResponse.resetBuffer();
            this.renderStack(session.getLocaleConfig(), iRequest, iResponse, t);
        }
    }

    private void renderStack(ILocaleConfig iLocaleConfig, HttpServletRequest iRequest, HttpServletResponse iResponse, Throwable t) throws IOException {
        iResponse.setContentType("text/html;charset=" + iLocaleConfig.getCharSet());
        iResponse.setHeader("Cache-Control", "no-store");
        iResponse.setHeader("Cache-Control", "no-cache");
        iResponse.setHeader("Pragma", "no-cache");
        iResponse.setDateHeader("Expires", 0L);
        PrintWriter htmlWriter = iResponse.getWriter();
        htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
        htmlWriter.print("<html lang=\"");
        htmlWriter.print(iLocaleConfig.getLocale().getLanguage());
        htmlWriter.println("\">");
        htmlWriter.println("<head>");
        htmlWriter.println("<title>Error</title>");
        htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset=" + iLocaleConfig.getCharSet() + "'>");
        htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
        htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
        htmlWriter.println("<meta http-equiv='expires' content='0'>");
        htmlWriter.print("<base href='");
        htmlWriter.print(iRequest.getScheme());
        htmlWriter.print("://");
        htmlWriter.print(iRequest.getServerName());
        htmlWriter.print(":");
        htmlWriter.print(String.valueOf(iRequest.getServerPort()));
        htmlWriter.print(iRequest.getContextPath());
        htmlWriter.print("/");
        htmlWriter.println("'>");
        htmlWriter.println("</head>");
        htmlWriter.println("<body bgcolor='#FFFFFF' style='font-family: Verdana; color: #192c8f'>");
        HtmlUtils.writeStack(htmlWriter, t);
        htmlWriter.println("</body>");
        htmlWriter.println("</html>");
        htmlWriter.flush();
        htmlWriter.close();
    }
}

