/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LanguageBar
extends BaseBeanProvider
implements IView,
IXmlObject {
    private Application _xmlroot;
    private String _xmlattr_opt_CssClass = "LanguageBar";
    private String _xmlattr_opt_LocaleBeanName = "$locale";
    private IBinding _xmlnode_req_Locale;
    private IImage _xmlnode_opt_FlagIcon;

    public void checkThisNode(Object validSupport, IValidityLogger iErrors) {
        this._xmlroot.registerRequestHandler("langbar", this);
        if (this._xmlnode_req_Locale != null && !this._xmlnode_req_Locale.hasErrors()) {
            if (Locale.class != this._xmlnode_req_Locale.getType()) {
                iErrors.logMessage((IXmlObject)this, "Locale", 1, "This binding must return a java.util.Locale value.");
            } else if (!this._xmlnode_req_Locale.isGetSet()) {
                iErrors.logMessage((IXmlObject)this, "Locale", 1, "This binding must be settable (to set language when selected).");
            }
        }
    }

    public void preRender(HttpServletRequest request) throws Exception {
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale currentLocale = response.getLocale();
        ILocaleConfig[] languages = this._xmlroot.getAllLanguages();
        PrintWriter writer = response.getWriter();
        UrlBuilder changeLanguageUrl = this._xmlroot.createHandlerUrl(request, this, "onChange");
        writer.print("<div class='");
        writer.print(this._xmlattr_opt_CssClass);
        writer.println("'><ul>");
        for (int i = 0; i < languages.length; ++i) {
            boolean isSelected = currentLocale.getLanguage().equals(languages[i].getLocale().getLanguage());
            request.setAttribute(this._xmlattr_opt_LocaleBeanName, (Object)languages[i].getLocale());
            String flagImg = this._xmlnode_opt_FlagIcon == null ? null : this._xmlnode_opt_FlagIcon.getImage(request);
            writer.print("<li>");
            if (isSelected) {
                writer.print("<span class='selected'>");
            } else {
                changeLanguageUrl.setParameter("_lang", languages[i].getLocale().getLanguage());
                writer.print("<a href='");
                writer.print(changeLanguageUrl.toUrl(response.getCharacterEncoding(), true));
                writer.print("'>");
            }
            String languageName = languages[i].getLocale().getDisplayLanguage(currentLocale);
            if (this._xmlnode_opt_FlagIcon != null) {
                writer.print("<img src='");
                writer.write(flagImg);
                writer.print("' title='");
                writer.print(HtmlUtils.encode2HTML(languageName));
                writer.print("' alt='");
                writer.print("'/>");
            } else {
                writer.print(HtmlUtils.encode2HTML(languageName));
            }
            if (isSelected) {
                writer.print("</span>");
            } else {
                writer.print("</a>");
            }
            writer.println("</li>");
        }
        writer.println("</ul></div>");
    }

    public void onChange(HttpServletRequest iRequest, HttpServletResponse response) throws Exception {
        String lang = iRequest.getParameter("_lang");
        Locale currentLocale = response.getLocale();
        Locale newLocale = new Locale(lang, currentLocale.getCountry());
        this._xmlnode_req_Locale.setValue(iRequest, newLocale);
        BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
        response.sendRedirect(url.toUrl(response.getCharacterEncoding(), false));
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_LocaleBeanName.equals(iName)) {
            return Locale.class;
        }
        return this.getParentBeanType(iName);
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_LocaleBeanName.equals(iName)) {
            return Locale.class;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this._xmlattr_opt_LocaleBeanName.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return this.getParentBeanValue(iRequest, iName);
    }
}

