/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.form.IFormItem;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.RenderingContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseForm
implements IXmlObject,
IIdentifiable,
IView {
    protected Application _xmlroot;
    protected String _xmlattr_req_ID;
    protected String _xmlattr_opt_CssClass = "Form";
    protected IFormItem[] _xmlnode_1_unb_Items;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "Form_" + this._xmlattr_req_ID;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlroot.registerRequestHandler(this.getPathID(), this) != null) {
            iErrors.logMessage((IXmlObject)this, "ID", 5, "Submit URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        }
    }

    public String getID() {
        return this._xmlattr_req_ID;
    }

    public abstract boolean isEditable(HttpServletRequest var1);

    public abstract boolean isEditing(HttpServletRequest var1);

    public abstract void renderGlobalErrors(HttpServletRequest var1, HttpServletResponse var2, FormRenderingContext var3) throws Exception;

    public abstract void renderButtons(HttpServletRequest var1, HttpServletResponse var2, FormRenderingContext var3) throws Exception;

    public FormSubmitContext getSubmitContext(HttpServletRequest iRequest) {
        return (FormSubmitContext)iRequest.getAttribute("$submitctx." + this.getID());
    }

    protected void setSubmitContext(HttpServletRequest iRequest, FormSubmitContext iSubmitContext) {
        iRequest.setAttribute("$submitctx." + this.getID(), (Object)iSubmitContext);
    }

    public FormRenderingContext getRenderingContext(HttpServletRequest iRequest) {
        return (FormRenderingContext)iRequest.getAttribute("$renderctx." + this.getID());
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        FormRenderingContext context = new FormRenderingContext();
        context.editable = this.isEditable(iRequest);
        context.editMode = context.editable && this.isEditing(iRequest);
        context.form = this;
        context.submitContext = this.getSubmitContext(iRequest);
        iRequest.setAttribute("$renderctx." + this.getID(), (Object)context);
        for (int i = 0; i < this._xmlnode_1_unb_Items.length; ++i) {
            this._xmlnode_1_unb_Items[i].preRender(iRequest);
        }
        RenderingContext.get(iRequest).put(this, "ctx", context);
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        FormRenderingContext context = (FormRenderingContext)RenderingContext.get(iRequest).get(this, "ctx");
        iRequest.setAttribute("#formctx", (Object)context);
        PrintWriter iWriter = iResponse.getWriter();
        if (context.editMode) {
            HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
        }
        iWriter.println("<div class='" + this._xmlattr_opt_CssClass + "'>");
        if (context.editMode) {
            iWriter.print("<form name='" + this.getID() + "' method='post' action='");
            iWriter.print(BricksUrlBuilder.copyFromRequest(iRequest, true).toUrl(iRequest.getCharacterEncoding(), true));
            iWriter.println("'>");
            iWriter.print("<input type='hidden' name='");
            iWriter.print(this._xmlroot.getHandlerParamName());
            iWriter.print("'");
            iWriter.print(" value='");
            iWriter.print(this._xmlroot.getHandlerParamValue(this, "submit"));
            iWriter.print("'");
            iWriter.println("/>");
        }
        this.renderGlobalErrors(iRequest, iResponse, context);
        iWriter.println("<div class=Fields>");
        for (int i = 0; i < this._xmlnode_1_unb_Items.length; ++i) {
            context.oddField = i % 2 == 0;
            this._xmlnode_1_unb_Items[i].render(iRequest, iResponse);
        }
        iWriter.println("</div>");
        this.renderButtons(iRequest, iResponse, context);
        if (context.editMode) {
            iWriter.println("</form>");
        }
        iWriter.println("</div>");
        if (context.editMode && iRequest.getAttribute("_FORM_FOCUS_FIRST_") == null) {
            iWriter.println("<script language='javascript' type='text/javascript'>");
            iWriter.println("Form_focusFirstInput('" + this.getID() + "');");
            iWriter.println("</script>");
            iRequest.setAttribute("_FORM_FOCUS_FIRST_", (Object)Boolean.TRUE);
        }
    }
}

