/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import java.io.PrintWriter;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditForm
extends BaseForm {
    private IMessage _xmlnode_opt_SubmitButtonLabel;
    private IBinding _xmlnode_opt_OnValidate;
    private IAction _xmlnode_opt_OnSubmit;
    private IBinding[] _xmlnode_0_unb_OnResetChange;
    private IAction _xmlnode_opt_OnCancel;

    public boolean isEditable(HttpServletRequest iRequest) {
        return true;
    }

    public boolean isEditing(HttpServletRequest iRequest) {
        return true;
    }

    public void submit(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        if (!this.isEditable(iRequest)) {
            throw new Exception("Forbidden access");
        }
        FormSubmitContext submitCtx = new FormSubmitContext(iRequest.getParameter("action"));
        this.setSubmitContext(iRequest, submitCtx);
        for (int ikey = 0; ikey < this._xmlnode_1_unb_Items.length; ++ikey) {
            this._xmlnode_1_unb_Items[ikey].submit(iRequest, submitCtx);
        }
        if (!submitCtx.isSubmitAction()) {
            return;
        }
        if (this._xmlnode_opt_OnValidate != null) {
            try {
                this._xmlnode_opt_OnValidate.invoke(iRequest);
            }
            catch (ValidationErrors e) {
                submitCtx.getValidationErrors().addErrors(e);
            }
        }
        if (submitCtx.getValidationErrors().hasErrors()) {
            return;
        }
        if (this._xmlnode_opt_OnSubmit == null) {
            return;
        }
        this._xmlnode_opt_OnSubmit.invoke(iRequest, iResponse);
    }

    public void renderGlobalErrors(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        List<IValidationMessage> errors;
        FormSubmitContext submitCtx = this.getSubmitContext(iRequest);
        if (submitCtx != null && submitCtx.isSubmitAction() && (errors = submitCtx.getValidationErrors().getGlobalErrors()) != null && errors.size() > 0) {
            PrintWriter iWriter = iResponse.getWriter();
            iWriter.println("<ul class=errors>");
            for (int i = 0; i < errors.size(); ++i) {
                iWriter.print("<li>");
                iWriter.print(HtmlUtils.encode2HTML(errors.get(i).getMessage(iRequest)));
                iWriter.println("</li>");
            }
            iWriter.println("</ul>");
        }
    }

    public void renderButtons(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.println("<input type='hidden' name='action' value='submit'/>");
        int nbButtons = 0;
        if (this._xmlnode_opt_OnSubmit != null) {
            ++nbButtons;
        }
        if (this._xmlnode_opt_OnCancel != null) {
            ++nbButtons;
        }
        if (this._xmlnode_0_unb_OnResetChange != null && this._xmlnode_0_unb_OnResetChange.length > 0) {
            ++nbButtons;
        }
        if (nbButtons == 0) {
            return;
        }
        ResourceBundle msgs = BricksMessages.getBundle(iResponse.getLocale());
        iWriter.print("<div class='Buttons'>");
        iWriter.print("<ul>");
        if (this._xmlnode_opt_OnSubmit != null) {
            String submitLabel = null;
            submitLabel = this._xmlnode_opt_SubmitButtonLabel != null ? this._xmlnode_opt_SubmitButtonLabel.getMessage(iRequest) : msgs.getString("button.submit");
            iWriter.print("<li>");
            iWriter.print("<input type='submit' value=\"");
            iWriter.print(HtmlUtils.encode2HTML(submitLabel));
            iWriter.print("\">");
            iWriter.println("</li>");
        }
        if (this._xmlnode_0_unb_OnResetChange != null && this._xmlnode_0_unb_OnResetChange.length > 0) {
            String resetUrl = this._xmlroot.createHandlerUrl(iRequest, this, "reset").toUrl(iRequest.getCharacterEncoding(), true);
            iWriter.print("<li>");
            iWriter.print("<a href='");
            iWriter.print(resetUrl);
            iWriter.print("'>");
            iWriter.print(msgs.getString("button.reset"));
            iWriter.print("</a>");
            iWriter.println("</li>");
        }
        if (this._xmlnode_opt_OnCancel != null) {
            String cancelUrl = this._xmlnode_opt_OnCancel.getURL(iRequest, true);
            iWriter.print("<li>");
            iWriter.print("<a href='");
            iWriter.print(cancelUrl);
            iWriter.print("'>");
            iWriter.print(msgs.getString("button.cancel"));
            iWriter.print("</a>");
            iWriter.println("</li>");
        }
        iWriter.print("</ul>");
        iWriter.println("</div>");
    }

    public void reset(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        if (this._xmlnode_0_unb_OnResetChange != null) {
            for (int i = 0; i < this._xmlnode_0_unb_OnResetChange.length; ++i) {
                this._xmlnode_0_unb_OnResetChange[i].invoke(iRequest);
            }
        }
    }
}

