/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import java.io.PrintWriter;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewEditForm
extends BaseForm {
    private boolean _xmlattr_opt_ShowResetButton = true;
    private IMessage _xmlnode_opt_SubmitButtonLabel;
    private IBoolExpr _xmlnode_opt_Editable;
    private IMenuItem[] _xmlnode_0_unb_AddButtons;
    private IBinding[] _xmlnode_0_unb_OnReload;
    private IBinding _xmlnode_opt_OnValidate;
    private IAction _xmlnode_req_OnSubmit;
    private IBinding[] _xmlnode_1_unb_OnResetChange;

    public boolean isEditable(HttpServletRequest iRequest) {
        if (this._xmlnode_opt_Editable == null) {
            return true;
        }
        return this._xmlnode_opt_Editable.eval(iRequest);
    }

    public boolean isEditing(HttpServletRequest iRequest) {
        boolean editRequired = "edit".equals(iRequest.getParameter(this.getID() + ".mode"));
        return editRequired && this.isEditable(iRequest);
    }

    public void submit(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        if (!this.isEditable(iRequest)) {
            throw new Exception("Forbidden access");
        }
        BricksSession session = BricksSession.getSession(iRequest);
        session.getCurrentPageContext().setAttribute("form." + this.getID() + ".changed", Boolean.TRUE);
        FormSubmitContext submitCtx = new FormSubmitContext(iRequest.getParameter("action"));
        this.setSubmitContext(iRequest, submitCtx);
        for (int ikey = 0; ikey < this._xmlnode_1_unb_Items.length; ++ikey) {
            this._xmlnode_1_unb_Items[ikey].submit(iRequest, submitCtx);
        }
        if (!submitCtx.isSubmitAction()) {
            return;
        }
        if (this._xmlnode_opt_OnValidate != null) {
            try {
                this._xmlnode_opt_OnValidate.invoke(iRequest);
            }
            catch (ValidationErrors e) {
                submitCtx.getValidationErrors().addErrors(e);
            }
        }
        if (submitCtx.getValidationErrors().hasErrors()) {
            return;
        }
        this._xmlnode_req_OnSubmit.invoke(iRequest, iResponse);
    }

    public void renderGlobalErrors(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        List<IValidationMessage> errors;
        FormSubmitContext submitCtx = this.getSubmitContext(iRequest);
        if (submitCtx != null && submitCtx.isSubmitAction() && (errors = submitCtx.getValidationErrors().getGlobalErrors()) != null && errors.size() > 0) {
            PrintWriter iWriter = iResponse.getWriter();
            iWriter.println("<ul class=errors>");
            for (int i = 0; i < errors.size(); ++i) {
                iWriter.print("<li>");
                iWriter.print(HtmlUtils.encode2HTML(errors.get(i).getMessage(iRequest)));
                iWriter.println("</li>");
            }
            iWriter.println("</ul>");
        }
    }

    public void renderButtons(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.println("<input type='hidden' name='action' value='submit'/>");
        ResourceBundle msgs = BricksMessages.getBundle(iResponse.getLocale());
        iWriter.print("<div class='Buttons'>");
        iWriter.print("<ul>");
        if (iContext.editMode) {
            String submitLabel = null;
            submitLabel = this._xmlnode_opt_SubmitButtonLabel != null ? this._xmlnode_opt_SubmitButtonLabel.getMessage(iRequest) : msgs.getString("button.save");
            iWriter.print("<li>");
            iWriter.print("<input type='submit' value=\"");
            iWriter.print(HtmlUtils.encode2HTML(submitLabel));
            iWriter.print("\">");
            iWriter.println("</li>");
            if (this._xmlattr_opt_ShowResetButton) {
                String resetUrl = this._xmlroot.createHandlerUrl(iRequest, this, "reset").toUrl(iRequest.getCharacterEncoding(), true);
                iWriter.print("<li>");
                iWriter.print("<a href='");
                iWriter.print(resetUrl);
                iWriter.print("'>");
                iWriter.print(msgs.getString("button.reset"));
                iWriter.print("</a>");
                iWriter.println("</li>");
            }
            String cancelUrl = BricksUrlBuilder.copyFromRequest(iRequest, true).setParameter(this.getID() + ".mode", "view").toUrl(iRequest.getCharacterEncoding(), true);
            iWriter.print("<li>");
            iWriter.print("<a href='");
            iWriter.print(cancelUrl);
            iWriter.print("'>");
            iWriter.print(msgs.getString("button.cancel"));
            iWriter.print("</a>");
            iWriter.println("</li>");
            if (this._xmlnode_0_unb_AddButtons != null) {
                ILinkHrefRenderer disabledRenderer = new ILinkHrefRenderer(){

                    public boolean isEnabled(HttpServletRequest request) {
                        return false;
                    }

                    public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception {
                    }
                };
                for (int i = 0; i < this._xmlnode_0_unb_AddButtons.length; ++i) {
                    this._xmlnode_0_unb_AddButtons[i].render(iRequest, iResponse, disabledRenderer);
                }
            }
        } else {
            if (this.isEditable(iRequest)) {
                String editUrl = BricksUrlBuilder.copyFromRequest(iRequest, true).setParameter(this.getID() + ".mode", "edit").toUrl(iRequest.getCharacterEncoding(), true);
                iWriter.print("<li>");
                iWriter.print("<a href='");
                iWriter.print(editUrl);
                iWriter.print("'>");
                iWriter.print(msgs.getString("button.edit"));
                iWriter.print("</a>");
                iWriter.println("</li>");
            } else {
                iWriter.print("<li>");
                iWriter.print("<span class='disabled'>");
                iWriter.print(msgs.getString("button.edit"));
                iWriter.print("</span>");
                iWriter.println("</li>");
            }
            if (this._xmlnode_0_unb_OnReload != null && this._xmlnode_0_unb_OnReload.length > 0) {
                String reloadUrl = this._xmlroot.createHandlerUrl(iRequest, this, "reload").toUrl(iRequest.getCharacterEncoding(), true);
                iWriter.print("<li>");
                iWriter.print("<a href='");
                iWriter.print(reloadUrl);
                iWriter.print("'>");
                iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "button.reload")));
                iWriter.print("</a>");
                iWriter.println("</li>");
            }
            if (this._xmlnode_0_unb_AddButtons != null) {
                for (int i = 0; i < this._xmlnode_0_unb_AddButtons.length; ++i) {
                    this._xmlnode_0_unb_AddButtons[i].render(iRequest, iResponse, null);
                }
            }
        }
        iWriter.print("</ul>");
        iWriter.println("</div>");
    }

    public void reset(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        if (this._xmlnode_1_unb_OnResetChange != null) {
            for (int i = 0; i < this._xmlnode_1_unb_OnResetChange.length; ++i) {
                this._xmlnode_1_unb_OnResetChange[i].invoke(iRequest);
            }
            BricksSession session = BricksSession.getSession(iRequest);
            session.getCurrentPageContext().removeAttribute("form." + this.getID() + ".changed");
        }
    }

    public void reload(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        if (this._xmlnode_0_unb_OnReload != null) {
            for (int i = 0; i < this._xmlnode_0_unb_OnReload.length; ++i) {
                this._xmlnode_0_unb_OnReload[i].invoke(iRequest);
            }
            BricksSession session = BricksSession.getSession(iRequest);
            session.getCurrentPageContext().removeAttribute("form." + this.getID() + ".changed");
        }
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        BricksSession session;
        super.preRender(iRequest);
        if (!this.getRenderingContext((HttpServletRequest)iRequest).editMode && Boolean.TRUE.equals((session = BricksSession.getSession(iRequest)).getCurrentPageContext().getAttribute("form." + this.getID() + ".changed"))) {
            for (int i = 0; i < this._xmlnode_1_unb_OnResetChange.length; ++i) {
                this._xmlnode_1_unb_OnResetChange[i].invoke(iRequest);
            }
            session.getCurrentPageContext().removeAttribute("form." + this.getID() + ".changed");
        }
    }
}

