/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.IFormItem;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseEditableField
implements IXmlObject,
IFormItem,
IIdentifiable {
    private BaseForm _xmlancestor_Form;
    protected IMessage _xmlnode_req_Label;
    private IBoolExpr _xmlnode_opt_Visible;
    protected IBoolExpr _xmlnode_opt_Editable;
    protected IBinding _xmlnode_req_Bind;
    private IMenuItem[] _xmlnode_0_unb_FieldButtons;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "Field_" + this._xmlnode_req_Bind.getID();
    }

    protected BaseForm getForm() {
        return this._xmlancestor_Form;
    }

    public boolean isVisible(HttpServletRequest iRequest) {
        return this._xmlnode_opt_Visible == null || this._xmlnode_opt_Visible.eval(iRequest);
    }

    public boolean isEditable(HttpServletRequest iRequest) {
        if (!this.isVisible(iRequest)) {
            return false;
        }
        return this._xmlnode_opt_Editable == null || this._xmlnode_opt_Editable.eval(iRequest);
    }

    public abstract String getFieldName();

    public String getFieldId() {
        return this.getForm().getID() + "_" + this.getFieldName();
    }

    protected abstract void renderInput(HttpServletRequest var1, HttpServletResponse var2, FormRenderingContext var3) throws Exception;

    protected abstract boolean isMandatory(HttpServletRequest var1);

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        List<IValidationMessage> errors;
        int i;
        if (!this.isVisible(iRequest)) {
            return;
        }
        FormRenderingContext renderingCtx = this.getForm().getRenderingContext(iRequest);
        boolean mandatory = this.isMandatory(iRequest);
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.print("<div class='field");
        if (renderingCtx.isOddField()) {
            iWriter.print(" odd");
        } else {
            iWriter.print(" even");
        }
        if (mandatory) {
            iWriter.print(" mandatory");
        }
        iWriter.println("'>");
        iWriter.print("<label class=field");
        if (renderingCtx.isEditMode() && this.isEditable(iRequest)) {
            iWriter.print(" for='");
            iWriter.print(this.getFieldId());
            iWriter.print("'");
        }
        iWriter.print(">");
        iWriter.print(HtmlUtils.encode2HTML(this._xmlnode_req_Label.getMessage(iRequest)));
        iWriter.println("</label>");
        iWriter.print("<div class=input>");
        this.renderInput(iRequest, iResponse, renderingCtx);
        iWriter.println("</div>");
        if (this._xmlnode_0_unb_FieldButtons != null && this._xmlnode_0_unb_FieldButtons.length > 0) {
            ILinkHrefRenderer linkRenderer = null;
            if (renderingCtx.isEditMode()) {
                linkRenderer = new ILinkHrefRenderer(){

                    public boolean isEnabled(HttpServletRequest request) {
                        return false;
                    }

                    public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception {
                    }
                };
            }
            iWriter.println("<ul class=fieldbuttons>");
            for (i = 0; i < this._xmlnode_0_unb_FieldButtons.length; ++i) {
                this._xmlnode_0_unb_FieldButtons[i].render(iRequest, iResponse, linkRenderer);
            }
            iWriter.println("</ul>");
        }
        if (renderingCtx.getSubmitContext() != null && renderingCtx.getSubmitContext().isSubmitAction() && (errors = renderingCtx.getSubmitContext().getValidationErrors().getItemErrors(this.getFieldName())) != null && errors.size() > 0) {
            iWriter.println("<ul class=errors>");
            for (i = 0; i < errors.size(); ++i) {
                iWriter.print("<li>");
                iWriter.print(HtmlUtils.encode2HTML(errors.get(i).getMessage(iRequest)));
                iWriter.println("</li>");
            }
            iWriter.println("</ul>");
        }
        iWriter.println("</div>");
    }
}

