/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.form.field.BaseSingleValueField;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CheckBox
extends BaseSingleValueField {
    private boolean _xmlattr_opt_TrueIsChecked = true;
    private IBinding _xmlnode_opt_OnChange;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Bind != null && !this._xmlnode_req_Bind.hasErrors()) {
            Class<Boolean> type = Boolean.class;
            if (!ReflectionHelper.isBoolean(this._xmlnode_req_Bind.getType())) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Binding has invalid type.");
            }
            if (this._xmlnode_0_unb_Validators != null) {
                for (int i = 0; i < this._xmlnode_0_unb_Validators.length; ++i) {
                    if (this._xmlnode_0_unb_Validators[i].isTypeValid(type)) continue;
                    iErrors.logMessage((IXmlObject)this, "Validators", 1, "Validator " + i + " has invalid type.");
                }
            }
        }
    }

    public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder) {
        boolean checked;
        boolean bl = checked = iRequest.getParameter(this.getFieldName()) != null;
        if (this._xmlattr_opt_TrueIsChecked) {
            return new Boolean(checked);
        }
        return new Boolean(!checked);
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        if (this._xmlnode_opt_OnChange == null) {
            return;
        }
        FormSubmitContext submitCtx = this.getForm().getSubmitContext(iRequest);
        if (submitCtx != null && submitCtx.getAction().equals("change:" + this.getFieldName())) {
            this._xmlnode_opt_OnChange.invoke(iRequest);
        }
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        boolean showEditable = iContext.isEditMode() && this.isEditable(iRequest);
        Boolean checked = null;
        if (showEditable && iContext.getSubmitContext() != null) {
            checked = new Boolean(iRequest.getParameter(this.getFieldName()) != null);
        } else {
            boolean val = (Boolean)this._xmlnode_req_Bind.invoke(iRequest);
            checked = new Boolean(this._xmlattr_opt_TrueIsChecked ? val : !val);
        }
        if (checked == null) {
            checked = Boolean.TRUE;
        }
        if (this._xmlnode_opt_OnChange != null) {
            HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
        }
        iWriter.print("<input type='checkbox' class='checkbox'");
        iWriter.print(" id='");
        iWriter.print(this.getFieldId());
        iWriter.print("'");
        iWriter.print(" name='");
        iWriter.print(this.getFieldName());
        iWriter.print("'");
        if (checked.booleanValue()) {
            iWriter.print(" checked='checked'");
        }
        if (!showEditable) {
            iWriter.print(" disabled='disabled'");
        }
        if (showEditable && this._xmlnode_opt_OnChange != null) {
            iWriter.print(" onclick=\"Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')\"");
        }
        iWriter.print("/>");
    }
}

