/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.enums.DateType;
import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.html.form.BaseForm;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.field.BaseSingleValueField;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DateField
extends BaseSingleValueField {
    protected Application _xmlroot;
    protected IPage _xmlancestor_Page;
    protected BaseForm _xmlancestor_Form;
    private DateType _xmlattr_opt_Type = DateType.DateOnly;
    private static HashMap<String, String> key2Name = new HashMap();

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlroot.registerRequestHandler(this.getPathID(), this) != null) {
            iErrors.logMessage((IXmlObject)this, "ID", 5, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        }
        if (this._xmlnode_req_Bind != null && !this._xmlnode_req_Bind.hasErrors()) {
            Class type = this._xmlnode_req_Bind.getType();
            if (!ReflectionHelper.isDate(type)) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Binding has invalid type.");
            }
            if (this._xmlnode_0_unb_Validators != null) {
                for (int i = 0; i < this._xmlnode_0_unb_Validators.length; ++i) {
                    if (this._xmlnode_0_unb_Validators[i].isTypeValid(type)) continue;
                    iErrors.logMessage((IXmlObject)this, "Validators", 1, "Validator " + i + " has invalid type.");
                }
            }
        }
    }

    public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder) {
        Date date = null;
        if (this._xmlattr_opt_Type == DateType.DateAndTime || this._xmlattr_opt_Type == DateType.DateOnly) {
            String val = iRequest.getParameter(this.getFieldName());
            if (val == null) {
                return null;
            }
            if ((val = val.trim()).length() == 0) {
                return null;
            }
            BricksSession session = BricksSession.getSession(iRequest);
            DateFormat format = DateType.getInputFormat(session.getLocaleConfig(), DateType.DateOnly);
            try {
                date = format.parse(val);
            }
            catch (ParseException e) {
                iValidationHolder.addItemError(this.getFieldName(), new LocalizedMessage("validation.date.wrong_format", "bricks", new Object[]{format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : format.toString()}));
                return null;
            }
        }
        if (this._xmlattr_opt_Type == DateType.DateAndTime || this._xmlattr_opt_Type == DateType.TimeOnly) {
            int hours = Integer.parseInt(iRequest.getParameter(this.getFieldName() + "_h"));
            int minutes = Integer.parseInt(iRequest.getParameter(this.getFieldName() + "_m"));
            int seconds = Integer.parseInt(iRequest.getParameter(this.getFieldName() + "_s"));
            if (date == null) {
                date = new Date();
            }
            date.setHours(hours);
            date.setMinutes(minutes);
            date.setSeconds(seconds);
        }
        return ReflectionHelper.date2Obj(date, this._xmlnode_req_Bind.getType());
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        DateFormat format;
        PrintWriter iWriter = iResponse.getWriter();
        boolean editable = iContext.isEditable() && this.isEditable(iRequest);
        BricksSession session = BricksSession.getSession(iRequest);
        Date dateVal = null;
        String date = null;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().getValidationErrors() != null) {
            if (this._xmlattr_opt_Type == DateType.DateAndTime || this._xmlattr_opt_Type == DateType.DateOnly) {
                date = iRequest.getParameter(this.getFieldName());
            }
            if (this._xmlattr_opt_Type == DateType.DateAndTime || this._xmlattr_opt_Type == DateType.TimeOnly) {
                hours = Integer.parseInt(iRequest.getParameter(this.getFieldName() + "_h"));
                minutes = Integer.parseInt(iRequest.getParameter(this.getFieldName() + "_m"));
                seconds = Integer.parseInt(iRequest.getParameter(this.getFieldName() + "_s"));
            }
        } else {
            dateVal = ReflectionHelper.obj2Date(this._xmlnode_req_Bind.invoke(iRequest));
            if (dateVal != null) {
                format = DateType.getInputFormat(session.getLocaleConfig(), DateType.DateOnly);
                date = format.format(dateVal);
                hours = dateVal.getHours();
                minutes = dateVal.getMinutes();
                seconds = dateVal.getSeconds();
            }
        }
        if (date == null) {
            date = "";
        }
        if (editable) {
            if (iContext.isEditMode()) {
                HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
            }
            if (this._xmlattr_opt_Type == DateType.DateAndTime || this._xmlattr_opt_Type == DateType.DateOnly) {
                iWriter.print("<input type='text'");
                iWriter.print(" id='");
                iWriter.print(this.getFieldId());
                iWriter.print("'");
                iWriter.print(" name='");
                iWriter.print(this.getFieldName());
                iWriter.print("'");
                iWriter.print(" size='10'");
                if (!iContext.isEditMode()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.print(" value=\"");
                iWriter.print(HtmlUtils.encode2HTML(date));
                iWriter.print("\"");
                iWriter.print(">");
                if (iContext.isEditMode()) {
                    String calendarText = BricksMessages.getMessage(iResponse.getLocale(), "datefield.show_calendar");
                    UrlBuilder calendarUrl = this._xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
                    iWriter.print("<a class='CalendarButton'");
                    iWriter.print(" href='javascript:void(0)'");
                    iWriter.print(" onclick=\"");
                    iWriter.print("DateField_showCalendar(event, '" + this._xmlancestor_Form.getID() + "', '" + this.getFieldName() + "', '" + calendarUrl.toUrl(session.getLocaleConfig().getCharSet(), true) + "'); return false;");
                    iWriter.print("\"");
                    iWriter.print(" title=\"");
                    iWriter.print(HtmlUtils.encode2HTML(calendarText));
                    iWriter.print("\"");
                    iWriter.print(">");
                    iWriter.print(HtmlUtils.encode2HTML(calendarText));
                    iWriter.print("</a>");
                }
            }
            if (this._xmlattr_opt_Type == DateType.DateAndTime || this._xmlattr_opt_Type == DateType.TimeOnly) {
                int i;
                iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "datefield.hours")));
                iWriter.print("<select name='");
                iWriter.print(this.getFieldName());
                iWriter.print("_h'");
                if (!iContext.isEditMode()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.println(">");
                for (i = 0; i < 24; ++i) {
                    iWriter.print("<option value='");
                    iWriter.print(String.valueOf(i));
                    iWriter.print("'");
                    if (i == hours) {
                        iWriter.print(" selected='selected'");
                    }
                    iWriter.print(">");
                    iWriter.print(String.valueOf(i));
                    iWriter.println("</option>");
                }
                iWriter.println("</select>");
                iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "datefield.minutes")));
                iWriter.print("<select name='");
                iWriter.print(this.getFieldName());
                iWriter.print("_m'");
                if (!iContext.isEditMode()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.println(">");
                for (i = 0; i < 60; ++i) {
                    iWriter.print("<option value='");
                    iWriter.print(String.valueOf(i));
                    iWriter.print("'");
                    if (i == minutes) {
                        iWriter.print(" selected='selected'");
                    }
                    iWriter.print(">");
                    iWriter.print(String.valueOf(i));
                    iWriter.println("</option>");
                }
                iWriter.println("</select>");
                iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "datefield.seconds")));
                iWriter.print("<select name='");
                iWriter.print(this.getFieldName());
                iWriter.print("_s'");
                if (!iContext.isEditMode()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.println(">");
                for (i = 0; i < 60; ++i) {
                    iWriter.print("<option value='");
                    iWriter.print(String.valueOf(i));
                    iWriter.print("'");
                    if (i == seconds) {
                        iWriter.print(" selected='selected'");
                    }
                    iWriter.print(">");
                    iWriter.print(String.valueOf(i));
                    iWriter.println("</option>");
                }
                iWriter.println("</select>");
            }
        } else if (dateVal != null) {
            format = DateType.getInputFormat(session.getLocaleConfig(), this._xmlattr_opt_Type);
            iWriter.print(HtmlUtils.encode2HTML(format.format(dateVal)));
        }
    }

    private static String getMonthAndYearName(Locale locale, Calendar cal) {
        return DateField.getMonthName(locale, cal.get(5)) + " " + cal.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMonthName(Locale locale, int month) {
        String key = "m." + locale.getLanguage() + "." + month;
        String name = key2Name.get(key);
        if (name == null) {
            HashMap<String, String> hashMap = key2Name;
            synchronized (hashMap) {
                SimpleDateFormat sdf = new SimpleDateFormat("MMMMM", locale);
                Calendar.getInstance();
                Calendar cal = Calendar.getInstance(locale);
                cal.set(2, month);
                name = sdf.format(cal.getTime());
                key2Name.put(key, name);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDayName(Locale locale, int day) {
        String key = "d." + locale.getLanguage() + "." + day;
        String name = key2Name.get(key);
        if (name == null) {
            HashMap<String, String> hashMap = key2Name;
            synchronized (hashMap) {
                SimpleDateFormat sdf = new SimpleDateFormat("E", locale);
                Calendar.getInstance();
                Calendar cal = Calendar.getInstance(locale);
                cal.set(7, day);
                name = sdf.format(cal.getTime());
                key2Name.put(key, name);
            }
        }
        return name;
    }

    public static void main(String[] args) {
        Locale[] locales = new Locale[]{Locale.FRENCH, Locale.US, Locale.UK};
        System.out.println(" saturday: 7");
        System.out.println(" sunday: 1");
        System.out.println(" monday: 2");
        for (int i = 0; i < locales.length; ++i) {
            int j;
            Calendar cal = Calendar.getInstance(locales[i]);
            System.out.println("Locale " + locales[i]);
            System.out.println(" first day in week: " + cal.getFirstDayOfWeek() + " (" + DateField.getDayName(locales[i], cal.getFirstDayOfWeek()) + ")");
            for (j = 0; j < 12; ++j) {
                System.out.println(" month " + j + ": " + DateField.getMonthName(locales[i], j));
            }
            for (j = 0; j < 7; ++j) {
                System.out.println(" day " + j + ": " + DateField.getDayName(locales[i], j));
            }
        }
    }

    public void renderCalendar(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        int firstDayInWeek;
        BricksSession session = BricksSession.getSession(iRequest);
        DateFormat inputFormat = DateType.getInputFormat(session.getLocaleConfig(), DateType.DateOnly);
        String selectedStr = iRequest.getParameter("selected");
        Date selected = null;
        if (selectedStr != null) {
            selectedStr = selectedStr.trim();
            try {
                selected = inputFormat.parse(selectedStr);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        int month = 0;
        int year = 0;
        String monthStr = iRequest.getParameter("month");
        if (monthStr != null) {
            int idx = monthStr.indexOf(45);
            month = Integer.parseInt(monthStr.substring(0, idx)) - 1;
            year = Integer.parseInt(monthStr.substring(idx + 1));
        } else if (selected != null) {
            month = selected.getMonth();
            year = selected.getYear() + 1900;
        } else {
            Calendar displayedMonth = Calendar.getInstance(iResponse.getLocale());
            month = displayedMonth.get(2);
            year = displayedMonth.get(1);
        }
        Calendar cal = Calendar.getInstance(iResponse.getLocale());
        cal.set(year, month, 1, 0, 0, 0);
        SimpleDateFormat monthUrlFormat = new SimpleDateFormat("M-yyyy");
        SimpleDateFormat monthDisplayFormat = new SimpleDateFormat("MMMMM yyyy", iResponse.getLocale());
        iResponse.setContentType("text/html;charset=" + session.getLocaleConfig().getCharSet());
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
        iWriter.print("<html lang=\"");
        iWriter.print(session.getLocaleConfig().getLocale().getLanguage());
        iWriter.println("\">");
        iWriter.println("<head>");
        iWriter.print("<title>");
        iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "calendar.title", new Object[]{monthDisplayFormat.format(cal.getTime())})));
        iWriter.println("</title>");
        iWriter.println("<meta http-equiv='content-type' content='text/html;charset=" + session.getLocaleConfig().getCharSet() + "'>");
        iWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
        iWriter.println("<meta http-equiv='pragma' content='no-cache'>");
        iWriter.println("<meta http-equiv='expires' content='0'>");
        iWriter.print("<base href='");
        iWriter.print(iRequest.getScheme());
        iWriter.print("://");
        iWriter.print(iRequest.getServerName());
        iWriter.print(":");
        iWriter.print(String.valueOf(iRequest.getServerPort()));
        iWriter.print(iRequest.getContextPath());
        iWriter.print("/");
        iWriter.println("'>");
        IFrame frame = this._xmlroot.getFrame(this._xmlancestor_Page.getFrameName());
        CssStyleSheet[] styleSheets = frame.getStyleSheets();
        if (styleSheets != null) {
            for (int i = 0; i < styleSheets.length; ++i) {
                iWriter.print("<link rel='stylesheet' type='text/css' href='");
                iWriter.print(styleSheets[i].getFile());
                iWriter.println("'>");
            }
        }
        HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
        iWriter.println("</head>");
        iWriter.println("<body class=Calendar>");
        iWriter.println("<table class=Calendar>");
        iWriter.print("<tr class=Toolbar>");
        iWriter.print("<th colspan=8>");
        iWriter.print("<div>");
        cal.set(year, month, 1);
        cal.add(1, -1);
        UrlBuilder url = this._xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
        url.setParameter("month", monthUrlFormat.format(cal.getTime()));
        if (selected != null) {
            url.setParameter("selected", selectedStr);
        }
        iWriter.print("<a class='PrevYear' href='");
        iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
        iWriter.print("' title='");
        iWriter.print(monthDisplayFormat.format(cal.getTime()));
        iWriter.print("'>&nbsp;</a>");
        iWriter.print("&nbsp;");
        cal.set(year, month, 1);
        cal.add(2, -1);
        url = this._xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
        url.setParameter("month", monthUrlFormat.format(cal.getTime()));
        if (selected != null) {
            url.setParameter("selected", selectedStr);
        }
        iWriter.print("<a class='PrevMonth' href='");
        iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
        iWriter.print("' title='");
        iWriter.print(monthDisplayFormat.format(cal.getTime()));
        iWriter.print("'>&nbsp;</a>");
        iWriter.print("&nbsp;");
        cal.set(year, month, 1);
        iWriter.print("<span class='Title'>");
        iWriter.print(monthDisplayFormat.format(cal.getTime()));
        iWriter.print("</span>");
        iWriter.print("&nbsp;");
        cal.set(year, month, 1);
        cal.add(2, 1);
        url = this._xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
        url.setParameter("month", monthUrlFormat.format(cal.getTime()));
        if (selected != null) {
            url.setParameter("selected", selectedStr);
        }
        iWriter.print("<a class='NextMonth' href='");
        iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
        iWriter.print("' title='");
        iWriter.print(monthDisplayFormat.format(cal.getTime()));
        iWriter.print("'>&nbsp;</a>");
        iWriter.print("&nbsp;");
        cal.set(year, month, 1);
        cal.add(1, 1);
        url = this._xmlroot.createServiceUrl(iRequest, this, "renderCalendar");
        url.setParameter("month", monthUrlFormat.format(cal.getTime()));
        if (selected != null) {
            url.setParameter("selected", selectedStr);
        }
        iWriter.print("<a class='NextYear' href='");
        iWriter.print(url.toUrl(session.getLocaleConfig().getCharSet(), true));
        iWriter.print("' title='");
        iWriter.print(monthDisplayFormat.format(cal.getTime()));
        iWriter.print("'>&nbsp;</a>");
        iWriter.print("</div>");
        iWriter.print("</th>");
        iWriter.println("</tr>");
        cal.set(year, month, 1);
        iWriter.print("<tr class=DayNames>");
        iWriter.print("<th scope=col class=Week>");
        iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "calendar.week")));
        iWriter.print("</th>");
        int day = firstDayInWeek = cal.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            iWriter.print("<th scope=col>");
            iWriter.print(DateField.getDayName(iResponse.getLocale(), day));
            iWriter.print("</th>");
            if (++day <= 6) continue;
            day = 0;
        }
        iWriter.println("</tr>");
        cal.set(year, month, 1);
        int nbWeeks = cal.getActualMaximum(4);
        cal.set(4, 1);
        cal.set(7, firstDayInWeek);
        for (int i = 0; i < nbWeeks; ++i) {
            iWriter.print("<tr class=Week>");
            iWriter.print("<td class=Week>");
            iWriter.print("<span>");
            iWriter.print(String.valueOf(cal.get(3)));
            iWriter.print("</span>");
            iWriter.print("</td>");
            for (int j = 0; j < 7; ++j) {
                int dayInWeek = cal.get(7);
                Date dayDate = cal.getTime();
                iWriter.print("<td class=Day>");
                iWriter.print("<a class='Day");
                if (dayInWeek == 7 || dayInWeek == 1) {
                    iWriter.print(" WeekEnd");
                }
                if (cal.get(2) != month) {
                    iWriter.print(" OutMonth");
                }
                if (selected != null && selected.getYear() == dayDate.getYear() && selected.getMonth() == dayDate.getMonth() && selected.getDate() == dayDate.getDate()) {
                    iWriter.print(" Selected");
                }
                iWriter.print("'");
                iWriter.print(" href='javascript:void(0)'");
                iWriter.print(" onclick=\"");
                iWriter.print("DateField_setDateAndClose('" + this._xmlancestor_Form.getID() + "', '" + this.getFieldName() + "', '" + inputFormat.format(dayDate) + "'); return false;");
                iWriter.print("\"");
                iWriter.print(">");
                iWriter.print(String.valueOf(cal.get(5)));
                iWriter.print("</a>");
                iWriter.print("</td>");
                cal.add(6, 1);
            }
            iWriter.println("</tr>");
        }
        iWriter.println("</table>");
        iWriter.println("</body>");
        iWriter.println("</html>");
        iWriter.flush();
        iWriter.close();
    }
}

