/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.enums.IntegerFieldType;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.field.BaseSingleValueField;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IntegerField
extends BaseSingleValueField {
    private IntegerFieldType _xmlattr_opt_Type = IntegerFieldType.InputField;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Bind != null && !this._xmlnode_req_Bind.hasErrors()) {
            Class type = this._xmlnode_req_Bind.getType();
            if (!ReflectionHelper.isIntegerLike(this._xmlnode_req_Bind.getType())) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Binding " + this._xmlnode_req_Bind + " has invalid type: " + this._xmlnode_req_Bind.getType() + ". Either int or Integer is expected.");
            }
            if (this._xmlnode_0_unb_Validators != null) {
                for (int i = 0; i < this._xmlnode_0_unb_Validators.length; ++i) {
                    if (this._xmlnode_0_unb_Validators[i].isTypeValid(type)) continue;
                    iErrors.logMessage((IXmlObject)this, "Validators", 1, "Validator " + i + " has invalid type.");
                }
            }
        }
    }

    public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder) {
        String val = iRequest.getParameter(this.getFieldName());
        try {
            return ReflectionHelper.parse2Type(val, this._xmlnode_req_Bind.getType());
        }
        catch (NumberFormatException e) {
            iValidationHolder.addItemError(this.getFieldName(), new LocalizedMessage("validation.int.not_an_int", "bricks"));
            return null;
        }
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        boolean editable = iContext.isEditable() && this.isEditable(iRequest);
        String val = null;
        val = editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().getValidationErrors() != null ? iRequest.getParameter(this.getFieldName()) : String.valueOf(this._xmlnode_req_Bind.invoke(iRequest));
        if (val == null) {
            val = "";
        }
        if (this._xmlattr_opt_Type == IntegerFieldType.InputField) {
            if (editable) {
                iWriter.print("<input type='text'");
                iWriter.print(" id='");
                iWriter.print(this.getFieldId());
                iWriter.print("'");
                iWriter.print(" name='");
                iWriter.print(this.getFieldName());
                iWriter.print("'");
                iWriter.print(" size='10'");
                if (!iContext.isEditMode()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.print(" value=\"");
                iWriter.print(HtmlUtils.encode2HTML(val));
                iWriter.print("\"");
                iWriter.print(">");
            } else {
                iWriter.print(HtmlUtils.encode2HTML(val));
            }
        } else {
            iWriter.print("<div class=PercentageBar>");
            iWriter.print("<div class=Bar style='width: " + val + "%'>&nbsp;</div>");
            iWriter.print("<div class=Percentage>" + val + "%</div>");
            iWriter.println("</div>");
        }
    }
}

