/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.MultiChoiceType;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.form.field.BaseVectorValueField;
import com.ebm_ws.infra.bricks.components.base.html.item.DisplayableItem;
import com.ebm_ws.infra.bricks.components.base.html.item.IItemsProvider;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MultiChoiceField
extends BaseVectorValueField {
    private MultiChoiceType _xmlattr_opt_Type = MultiChoiceType.CheckBoxes;
    private int _xmlattr_opt_ListSize = 8;
    private Class bindingType;
    private IItemsProvider _xmlnode_req_Items;
    private IBinding _xmlnode_opt_OnChange;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Bind != null && !this._xmlnode_req_Bind.hasErrors()) {
            this.bindingType = ReflectionHelper.getVectorElementClass(this._xmlnode_req_Bind.getGenericType());
            if (this.bindingType == null) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Bound data must be vector data.");
            } else if (!ReflectionHelper.isIntegerLike(this.bindingType) && this.bindingType != String.class) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Bound data must be either String, Integer or int.");
            }
            if (this._xmlnode_req_Items != null && !ReflectionHelper.isAssignable(this.bindingType, this._xmlnode_req_Items.getItemValueType())) {
                iErrors.logMessage((IXmlObject)this, "Items", 1, "Items type (" + this._xmlnode_req_Items.getItemValueType() + ") incompatible with binding (" + this.bindingType + ")");
            }
        }
    }

    public List getValuesFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder) {
        String[] values = iRequest.getParameterValues(this.getFieldName());
        if (values == null) {
            return null;
        }
        if (ReflectionHelper.isIntegerLike(this.bindingType)) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (int i = 0; i < values.length; ++i) {
                ret.add(ReflectionHelper.parse2Type(values[i], this.bindingType));
            }
            return ret;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            ret.add(values[i]);
        }
        return ret;
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        if (this._xmlnode_opt_OnChange == null) {
            return;
        }
        FormSubmitContext submitCtx = this.getForm().getSubmitContext(iRequest);
        if (submitCtx != null && submitCtx.getAction().equals("change:" + this.getFieldName())) {
            this._xmlnode_opt_OnChange.invoke(iRequest);
        }
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        boolean showEditable = iContext.isEditMode() && this.isEditable(iRequest);
        DisplayableItem[] items = this._xmlnode_req_Items.getItems(iRequest);
        if (items == null || items.length == 0) {
            return;
        }
        List selected = null;
        selected = showEditable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction() ? this.getValuesFromRequest(iRequest, null) : ReflectionHelper.obj2List(this._xmlnode_req_Bind.invoke(iRequest));
        if (selected == null) {
            selected = new ArrayList();
        }
        if (showEditable) {
            HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
        }
        if (this._xmlattr_opt_Type == MultiChoiceType.CheckBoxes) {
            iWriter.println("<ul>");
            for (int i = 0; i < items.length; ++i) {
                boolean checked = false;
                for (int j = 0; j < selected.size(); ++j) {
                    if (!selected.get(j).equals(items[i].getValue())) continue;
                    checked = true;
                    break;
                }
                String id = this.getFieldId() + "_" + i;
                iWriter.print("<li>");
                if (showEditable && !items[i].isEnabled() && checked) {
                    iWriter.print("<input type='hidden'");
                    iWriter.print(" name='");
                    iWriter.print(this.getFieldName());
                    iWriter.print("'");
                    iWriter.print(" value='");
                    iWriter.print(String.valueOf(items[i].getValue()));
                    iWriter.print("'");
                    iWriter.print("/>");
                }
                iWriter.print("<input type='checkbox' class='checkbox'");
                iWriter.print(" name='");
                iWriter.print(this.getFieldName());
                iWriter.print("'");
                iWriter.print(" id='");
                iWriter.print(id);
                iWriter.print("'");
                if (!showEditable || !items[i].isEnabled()) {
                    iWriter.print(" disabled='disabled'");
                } else if (showEditable && this._xmlnode_opt_OnChange != null) {
                    iWriter.print(" onclick=\"Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')\"");
                }
                iWriter.print(" value='");
                iWriter.print(String.valueOf(items[i].getValue()));
                iWriter.print("'");
                if (checked) {
                    iWriter.print(" checked='checked'");
                }
                iWriter.print("/>");
                iWriter.print("<label for='");
                iWriter.print(id);
                iWriter.print("'");
                if (showEditable && items[i].isEnabled() && this._xmlnode_opt_OnChange != null) {
                    iWriter.print(" onclick=\"setTimeout(&quot;Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')&quot;, 0)\"");
                }
                iWriter.print(">");
                iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
                iWriter.print("</label>");
                iWriter.println("</li>");
            }
            iWriter.println("</ul>");
        } else {
            iWriter.print("<select");
            iWriter.print(" multiple='multiple'");
            iWriter.print(" id='");
            iWriter.print(this.getFieldId());
            iWriter.print("'");
            iWriter.print(" name='");
            iWriter.print(this.getFieldName());
            iWriter.print("'");
            iWriter.print(" size='");
            iWriter.print(String.valueOf(this._xmlattr_opt_ListSize));
            iWriter.print("'");
            if (!showEditable) {
                iWriter.print(" disabled='disabled'");
            }
            if (showEditable && this._xmlnode_opt_OnChange != null) {
                iWriter.print(" onchange=\"Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')\"");
            }
            iWriter.println(">");
            for (int i = 0; i < items.length; ++i) {
                iWriter.print("<option");
                iWriter.print(" value='");
                iWriter.print(String.valueOf(items[i].getValue()));
                iWriter.print("'");
                if (!items[i].isEnabled()) {
                    iWriter.print(" disabled='disabled'");
                }
                for (int j = 0; j < selected.size(); ++j) {
                    if (!selected.get(j).equals(items[i].getValue())) continue;
                    iWriter.print(" selected='selected'");
                    break;
                }
                iWriter.print(">");
                iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
                iWriter.println("</option>");
            }
            iWriter.println("</select>");
        }
    }
}

