/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.SingleChoiceType;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.FormSubmitContext;
import com.ebm_ws.infra.bricks.components.base.html.form.field.BaseSingleValueField;
import com.ebm_ws.infra.bricks.components.base.html.item.DisplayableItem;
import com.ebm_ws.infra.bricks.components.base.html.item.IItemsProvider;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SingleChoiceField
extends BaseSingleValueField {
    private SingleChoiceType _xmlattr_opt_Type = SingleChoiceType.ComboBox;
    private int _xmlattr_opt_ListSize = 8;
    private Class bindingType;
    private IItemsProvider _xmlnode_req_Items;
    private IBinding _xmlnode_opt_OnChange;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Bind != null && !this._xmlnode_req_Bind.hasErrors()) {
            this.bindingType = this._xmlnode_req_Bind.getType();
            if (this.bindingType == null) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Binding type not found.");
            } else if (!ReflectionHelper.isIntegerLike(this.bindingType) && this.bindingType != String.class) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Bound data must be either String, Integer or int.");
            }
            if (this._xmlnode_req_Items != null && !ReflectionHelper.isAssignable(this.bindingType, this._xmlnode_req_Items.getItemValueType())) {
                iErrors.logMessage((IXmlObject)this, "Items", 1, "Items type (" + this._xmlnode_req_Items.getItemValueType() + ") incompatible with binding (" + this.bindingType + ")");
            }
        }
        if (this.bindingType != null && this._xmlnode_0_unb_Validators != null) {
            for (int i = 0; i < this._xmlnode_0_unb_Validators.length; ++i) {
                if (this._xmlnode_0_unb_Validators[i].isTypeValid(this.bindingType)) continue;
                iErrors.logMessage((IXmlObject)this, "Validators", 1, "Validator " + i + " has invalid type.");
            }
        }
    }

    public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder) {
        String selected = iRequest.getParameter(this.getFieldName());
        if (selected == null) {
            return null;
        }
        return ReflectionHelper.parse2Type(selected, this.bindingType);
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        if (this._xmlnode_opt_OnChange == null) {
            return;
        }
        FormSubmitContext submitCtx = this.getForm().getSubmitContext(iRequest);
        if (submitCtx != null && submitCtx.getAction().equals("change:" + this.getFieldName())) {
            this._xmlnode_opt_OnChange.invoke(iRequest);
        }
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        boolean editable = iContext.isEditable() && this.isEditable(iRequest);
        boolean showEditable = editable && iContext.isEditMode();
        DisplayableItem[] items = this._xmlnode_req_Items.getItems(iRequest);
        if (items == null || items.length == 0) {
            throw new Exception("No item for SingleChoiceField.");
        }
        String selectedStr = null;
        selectedStr = editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction() ? iRequest.getParameter(this.getFieldName()) : String.valueOf(this._xmlnode_req_Bind.invoke(iRequest));
        if (selectedStr == null) {
            selectedStr = String.valueOf(items[0].getValue());
        }
        if (this._xmlnode_opt_OnChange != null) {
            HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Form.js");
        }
        if (this._xmlattr_opt_Type == SingleChoiceType.RadioButtons) {
            iWriter.println("<ul>");
            for (int i = 0; i < items.length; ++i) {
                String valStr = String.valueOf(items[i].getValue());
                String id = this.getFieldId() + "_" + i;
                boolean selected = selectedStr.equals(valStr);
                iWriter.print("<li>");
                iWriter.print("<input type='radio' class='radio'");
                iWriter.print(" name='");
                iWriter.print(this.getFieldName());
                iWriter.print("'");
                iWriter.print(" id='");
                iWriter.print(id);
                iWriter.print("'");
                if (!showEditable || !items[i].isEnabled()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.print(" value='");
                iWriter.print(valStr);
                iWriter.print("'");
                if (selected) {
                    iWriter.print(" checked='checked'");
                }
                if (showEditable && !selected && this._xmlnode_opt_OnChange != null) {
                    iWriter.print(" onclick=\"Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')\"");
                }
                iWriter.print("/>");
                iWriter.print("<label for='");
                iWriter.print(id);
                iWriter.print("'");
                if (showEditable && !selected && items[i].isEnabled() && this._xmlnode_opt_OnChange != null) {
                    iWriter.print(" onclick=\"setTimeout(&quot;Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')&quot;, 0)\"");
                }
                iWriter.print(">");
                iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
                iWriter.print("</label>");
                iWriter.println("</li>");
            }
            iWriter.println("</ul>");
        } else if (this._xmlattr_opt_Type == SingleChoiceType.ComboBox && !editable) {
            DisplayableItem item = null;
            for (int i = 0; i < items.length; ++i) {
                if (!selectedStr.equals(String.valueOf(items[i].getValue()))) continue;
                item = items[i];
                break;
            }
            if (item != null) {
                iWriter.print(HtmlUtils.encode2HTML(item.getText()));
            }
        } else {
            iWriter.print("<select");
            iWriter.print(" id='");
            iWriter.print(this.getFieldId());
            iWriter.print("'");
            iWriter.print(" name='");
            iWriter.print(this.getFieldName());
            iWriter.print("'");
            if (this._xmlattr_opt_Type == SingleChoiceType.List) {
                iWriter.print(" size='");
                iWriter.print(String.valueOf(this._xmlattr_opt_ListSize));
                iWriter.print("'");
            }
            if (!showEditable) {
                iWriter.print(" disabled='disabled'");
            }
            if (showEditable && this._xmlnode_opt_OnChange != null) {
                iWriter.print(" onchange=\"Form_submit('" + this.getForm().getID() + "', 'change:" + this.getFieldName() + "')\"");
            }
            iWriter.println(">");
            for (int i = 0; i < items.length; ++i) {
                String valStr = String.valueOf(items[i].getValue());
                iWriter.print("<option");
                iWriter.print(" value='");
                iWriter.print(valStr);
                iWriter.print("'");
                if (!items[i].isEnabled()) {
                    iWriter.print(" disabled='disabled'");
                }
                if (selectedStr.equals(valStr)) {
                    iWriter.print(" selected='selected'");
                }
                iWriter.print(">");
                iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
                iWriter.println("</option>");
            }
            iWriter.println("</select>");
        }
    }
}

