/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.form.field;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.form.FormRenderingContext;
import com.ebm_ws.infra.bricks.components.base.html.form.field.BaseSingleValueField;
import com.ebm_ws.infra.bricks.components.base.html.form.field.IAutocomplete;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TextField
extends BaseSingleValueField {
    private int _xmlattr_opt_Rows = 1;
    private int _xmlattr_opt_Cols = 20;
    private IBoolExpr _xmlnode_opt_IsPassword;
    private IAutocomplete _xmlnode_opt_Autocomplete;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Bind != null && !this._xmlnode_req_Bind.hasErrors()) {
            Class<String> type = String.class;
            if (!type.isAssignableFrom(this._xmlnode_req_Bind.getType())) {
                iErrors.logMessage((IXmlObject)this, "Bind", 1, "Binding has invalid type.");
            }
            if (this._xmlnode_0_unb_Validators != null) {
                for (int i = 0; i < this._xmlnode_0_unb_Validators.length; ++i) {
                    if (this._xmlnode_0_unb_Validators[i].isTypeValid(type)) continue;
                    iErrors.logMessage((IXmlObject)this, "Validators", 1, "Validator " + i + " has invalid type.");
                }
            }
        }
    }

    public Object getValueFromRequest(HttpServletRequest iRequest, ValidationErrors iValidationHolder) {
        return iRequest.getParameter(this.getFieldName());
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        boolean editable = iContext.isEditable() && this.isEditable(iRequest);
        String val = null;
        val = editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction() ? iRequest.getParameter(this.getFieldName()) : (String)this._xmlnode_req_Bind.invoke(iRequest);
        if (val == null) {
            val = "";
        }
        if (this._xmlattr_opt_Rows > 1) {
            iWriter.print("<textarea");
            iWriter.print(" id='");
            iWriter.print(this.getFieldId());
            iWriter.print("'");
            iWriter.print(" name='");
            iWriter.print(this.getFieldName());
            iWriter.print("'");
            iWriter.print(" cols='");
            iWriter.print(String.valueOf(this._xmlattr_opt_Cols));
            iWriter.print("'");
            iWriter.print(" rows='");
            iWriter.print(String.valueOf(this._xmlattr_opt_Rows));
            iWriter.print("'");
            if (!editable || !iContext.isEditMode()) {
                iWriter.print(" disabled='disabled'");
            }
            iWriter.print(">");
            iWriter.print(TextField.encodeTextarea(val));
            iWriter.print("</textarea>");
        } else {
            boolean password;
            boolean bl = password = this._xmlnode_opt_IsPassword != null && this._xmlnode_opt_IsPassword.eval(iRequest);
            if (editable) {
                iWriter.print("<input");
                if (password) {
                    iWriter.print(" type='password'");
                } else {
                    iWriter.print(" type='text'");
                }
                iWriter.print(" id='");
                iWriter.print(this.getFieldId());
                iWriter.print("'");
                iWriter.print(" name='");
                iWriter.print(this.getFieldName());
                iWriter.print("'");
                iWriter.print(" size='");
                iWriter.print(String.valueOf(this._xmlattr_opt_Cols));
                iWriter.print("'");
                if (!iContext.isEditMode()) {
                    iWriter.print(" disabled='disabled'");
                }
                iWriter.print(" value=\"");
                iWriter.print(HtmlUtils.encode2HTML(val));
                iWriter.print("\"");
                iWriter.print(">");
                if (!password && this._xmlnode_opt_Autocomplete != null) {
                    String jsCallbackFnName = "onChange_" + TextField.toJsFunctionName(this.getForm().getID()) + "_" + TextField.toJsFunctionName(this.getFieldName());
                    this._xmlnode_opt_Autocomplete.renderJsAutocomplete(jsCallbackFnName, iRequest, iResponse);
                    iWriter.println("<script language='javascript' type='text/javascript'>");
                    iWriter.println("Autocomplete_init('" + this.getForm().getID() + "', '" + this.getFieldName() + "', " + jsCallbackFnName + ");");
                    iWriter.println("</script>");
                }
            } else if (password) {
                iWriter.print("*****");
            } else {
                iWriter.print(HtmlUtils.encode2HTML(val));
            }
        }
    }

    private static String toJsFunctionName(String text) {
        int nbChars = text.length();
        StringBuffer sb = new StringBuffer(nbChars);
        for (int i = 0; i < nbChars; ++i) {
            char c = text.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static String encodeTextarea(String text) {
        int nbChars = text.length();
        StringBuffer sb = new StringBuffer(nbChars);
        block4: for (int i = 0; i < nbChars; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

