/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.item;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.item.DisplayableItem;
import com.ebm_ws.infra.bricks.components.base.html.item.IItemsProvider;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DynamicItems
extends BaseBeanProvider
implements IXmlObject,
IItemsProvider {
    private String _xmlattr_opt_ItemBeanName = "$item";
    private IBinding _xmlnode_req_Items;
    private IBinding _xmlnode_opt_Value;
    private IMessage _xmlnode_opt_Text;
    private IBoolExpr _xmlnode_opt_Disabled;
    private Type itemType;
    private Class itemClass;
    private Class itemValueClass;

    private void initialize() {
        if (this.itemClass != null) {
            return;
        }
        if (this._xmlnode_req_Items != null && !this._xmlnode_req_Items.hasErrors()) {
            this.itemClass = ReflectionHelper.getVectorElementClass(this._xmlnode_req_Items.getGenericType());
            this.itemType = ReflectionHelper.getVectorElementType(this._xmlnode_req_Items.getGenericType());
            this.itemValueClass = this._xmlnode_opt_Value != null && !this._xmlnode_opt_Value.hasErrors() ? this._xmlnode_opt_Value.getType() : this.itemClass;
        }
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Items != null && !this._xmlnode_req_Items.hasErrors()) {
            if (this.itemClass == null) {
                this.initialize();
            }
            if (this.itemClass == null) {
                iErrors.logMessage((IXmlObject)this, "Items", 1, "Bound items must be vector data.");
            }
        }
    }

    public DisplayableItem[] getItems(HttpServletRequest iRequest) throws Exception {
        List itemObjs = ReflectionHelper.obj2List(this._xmlnode_req_Items.invoke(iRequest));
        if (itemObjs == null) {
            return null;
        }
        DisplayableItem[] items = new DisplayableItem[itemObjs.size()];
        for (int i = 0; i < itemObjs.size(); ++i) {
            iRequest.setAttribute(this._xmlattr_opt_ItemBeanName, itemObjs.get(i));
            Object value = itemObjs.get(i);
            if (this._xmlnode_opt_Value != null) {
                value = this._xmlnode_opt_Value.invoke(iRequest);
            }
            String text = this._xmlnode_opt_Text == null ? String.valueOf(value) : this._xmlnode_opt_Text.getMessage(iRequest);
            items[i] = new DisplayableItem(value, text);
            if (this._xmlnode_opt_Disabled == null) continue;
            items[i].setEnabled(!this._xmlnode_opt_Disabled.eval(iRequest));
        }
        return items;
    }

    public Class getItemValueType() {
        if (this.itemClass == null) {
            this.initialize();
        }
        return this.itemValueClass;
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            if (this.itemClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemClass;
        }
        return this.getParentBeanType(iName);
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            if (this.itemType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemType;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return this.getParentBeanValue(iRequest, iName);
    }
}

