/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.menu;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Button
implements IXmlObject,
IMenuItem {
    private String _xmlattr_opt_Target;
    private IMessage _xmlnode_req_Title;
    private IMessage _xmlnode_opt_Tooltip;
    private IImage _xmlnode_opt_Icon;
    private IAction _xmlnode_req_OnClick;
    private IBoolExpr _xmlnode_opt_Disabled;
    private IBoolExpr _xmlnode_opt_Visible;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    private boolean isVisible(HttpServletRequest iRequest) {
        if (this._xmlnode_opt_Visible == null) {
            return true;
        }
        return this._xmlnode_opt_Visible.eval(iRequest);
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, ILinkHrefRenderer iLinkRenderer) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        if (!this.isVisible(iRequest)) {
            return;
        }
        boolean rendererDisabled = iLinkRenderer != null && !iLinkRenderer.isEnabled(iRequest);
        boolean disabled = rendererDisabled || this._xmlnode_opt_Disabled != null && this._xmlnode_opt_Disabled.eval(iRequest);
        String iconSrc = this._xmlnode_opt_Icon == null ? null : this._xmlnode_opt_Icon.getImage(iRequest);
        String title = this._xmlnode_req_Title.getMessage(iRequest);
        String tooltip = this._xmlnode_opt_Tooltip == null ? null : this._xmlnode_opt_Tooltip.getMessage(iRequest);
        iWriter.print("<li>");
        if (disabled) {
            iWriter.print("<span class='disabled'");
        } else {
            iWriter.print("<a");
            if (iLinkRenderer != null) {
                iLinkRenderer.renderHref(iRequest, iResponse, this._xmlnode_req_OnClick.getURL(iRequest, true));
            } else {
                iWriter.print(" href='");
                iWriter.print(this._xmlnode_req_OnClick.getURL(iRequest, true));
                iWriter.print("'");
            }
            if (this._xmlattr_opt_Target != null) {
                iWriter.print(" target='");
                iWriter.print(this._xmlattr_opt_Target);
                iWriter.print("'");
            }
        }
        if (tooltip != null) {
            iWriter.print(" title='");
            iWriter.print(HtmlUtils.encode2HTML(tooltip));
            iWriter.print("'");
        }
        iWriter.print(">");
        if (iconSrc != null) {
            iWriter.print("<img src='");
            iWriter.print(iconSrc);
            iWriter.print("' alt='");
            if (tooltip != null) {
                iWriter.print(HtmlUtils.encode2HTML(tooltip));
            }
            iWriter.print("'/>");
        }
        iWriter.print(HtmlUtils.encode2HTML(title));
        if (disabled) {
            iWriter.print("</span>");
        } else {
            iWriter.print("</a>");
        }
        iWriter.println("</li>");
    }
}

