/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.menu;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicButtons
extends BaseBeanProvider
implements IXmlObject,
IMenuItem,
IBeanProvider {
    private String _xmlattr_opt_ItemBeanName = "$item";
    private IBinding _xmlnode_req_Items;
    private IMessage _xmlnode_req_Title;
    private IMessage _xmlnode_opt_Tooltip;
    private IImage _xmlnode_opt_Icon;
    private IAction _xmlnode_req_OnClick;
    private IBoolExpr _xmlnode_opt_Disabled;
    private IBoolExpr _xmlnode_opt_Visible;
    private Type itemType;
    private Class itemClass;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Items != null && !this._xmlnode_req_Items.hasErrors()) {
            this.itemClass = ReflectionHelper.getVectorElementClass(this._xmlnode_req_Items.getGenericType());
            this.itemType = ReflectionHelper.getVectorElementType(this._xmlnode_req_Items.getGenericType());
            if (this.itemClass == null) {
                iErrors.logMessage((IXmlObject)this, "Items", 1, "Bound items must be vector data.");
            }
        }
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, ILinkHrefRenderer iLinkRenderer) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        List items = ReflectionHelper.obj2List(this._xmlnode_req_Items.invoke(iRequest));
        if (items == null || items.isEmpty()) {
            return;
        }
        boolean rendererDisabled = iLinkRenderer != null && !iLinkRenderer.isEnabled(iRequest);
        for (int i = 0; i < items.size(); ++i) {
            boolean visible;
            iRequest.setAttribute(this._xmlattr_opt_ItemBeanName, items.get(i));
            boolean bl = visible = this._xmlnode_opt_Visible == null || this._xmlnode_opt_Visible.eval(iRequest);
            if (!visible) continue;
            boolean disabled = rendererDisabled || this._xmlnode_opt_Disabled != null && this._xmlnode_opt_Disabled.eval(iRequest);
            String iconSrc = this._xmlnode_opt_Icon == null ? null : this._xmlnode_opt_Icon.getImage(iRequest);
            String title = this._xmlnode_req_Title.getMessage(iRequest);
            String tooltip = this._xmlnode_opt_Tooltip == null ? null : this._xmlnode_opt_Tooltip.getMessage(iRequest);
            iWriter.print("<li>");
            if (disabled) {
                iWriter.print("<span class='disabled'");
            } else {
                iWriter.print("<a");
                if (iLinkRenderer != null) {
                    iLinkRenderer.renderHref(iRequest, iResponse, this._xmlnode_req_OnClick.getURL(iRequest, true));
                } else {
                    iWriter.print(" href='");
                    iWriter.print(this._xmlnode_req_OnClick.getURL(iRequest, true));
                    iWriter.print("'");
                }
            }
            if (tooltip != null) {
                iWriter.print(" title='");
                iWriter.print(HtmlUtils.encode2HTML(tooltip));
                iWriter.print("'");
            }
            iWriter.print(">");
            if (iconSrc != null) {
                iWriter.print("<img src='");
                iWriter.print(iconSrc);
                iWriter.print("' alt='");
                if (tooltip != null) {
                    iWriter.print(HtmlUtils.encode2HTML(tooltip));
                }
                iWriter.print("'/>");
            }
            iWriter.print(HtmlUtils.encode2HTML(title));
            if (disabled) {
                iWriter.print("</span>");
            } else {
                iWriter.print("</a>");
            }
            iWriter.println("</li>");
        }
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            if (this.itemClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemClass;
        }
        return this.getParentBeanType(iName);
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            if (this.itemType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemType;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return this.getParentBeanValue(iRequest, iName);
    }
}

