/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.menu;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SubMenu
implements IXmlObject,
IMenuItem {
    private String _xmlattr_opt_Target;
    private IMessage _xmlnode_req_Title;
    private IMessage _xmlnode_opt_Tooltip;
    private IImage _xmlnode_opt_Icon;
    private IAction _xmlnode_opt_OnClick;
    private IBoolExpr _xmlnode_opt_Disabled;
    private IMenuItem[] _xmlnode_1_unb_Items;
    private IBoolExpr _xmlnode_opt_Visible;
    private IBoolExpr _xmlnode_opt_ShowSubMenu;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, ILinkHrefRenderer iLinkRenderer) throws Exception {
        if (this._xmlnode_opt_Visible != null && !this._xmlnode_opt_Visible.eval(iRequest)) {
            return;
        }
        String iconSrc = this._xmlnode_opt_Icon == null ? null : this._xmlnode_opt_Icon.getImage(iRequest);
        String title = this._xmlnode_req_Title.getMessage(iRequest);
        String tooltip = this._xmlnode_opt_Tooltip == null ? null : this._xmlnode_opt_Tooltip.getMessage(iRequest);
        boolean rendererDisabled = iLinkRenderer != null && !iLinkRenderer.isEnabled(iRequest);
        boolean isHyperLink = !rendererDisabled && this._xmlnode_opt_OnClick != null && (this._xmlnode_opt_Disabled == null || !this._xmlnode_opt_Disabled.eval(iRequest));
        boolean showSubMenu = this._xmlnode_opt_ShowSubMenu == null || this._xmlnode_opt_ShowSubMenu.eval(iRequest);
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.print("<li");
        if (showSubMenu) {
            iWriter.print(" class=submenu");
        }
        iWriter.print(">");
        if (isHyperLink || showSubMenu) {
            iWriter.print("<a");
            if (showSubMenu) {
                iWriter.print(" class=submenu onfocus='Menu_focus(this)' onblur='Menu_blur(this)'");
            }
            if (isHyperLink) {
                if (iLinkRenderer != null) {
                    iLinkRenderer.renderHref(iRequest, iResponse, this._xmlnode_opt_OnClick.getURL(iRequest, true));
                } else {
                    iWriter.print(" href='");
                    iWriter.print(this._xmlnode_opt_OnClick.getURL(iRequest, true));
                    iWriter.print("'");
                }
                if (this._xmlattr_opt_Target != null) {
                    iWriter.print(" target='");
                    iWriter.print(this._xmlattr_opt_Target);
                    iWriter.print("'");
                }
            } else {
                iWriter.print(" href='javascript:void(0)'");
            }
        } else {
            iWriter.print("<span class=disabled");
        }
        if (tooltip != null) {
            iWriter.print(" title='");
            iWriter.print(HtmlUtils.encode2HTML(tooltip));
            iWriter.print("'");
        }
        iWriter.print(">");
        if (iconSrc != null) {
            iWriter.print("<img src='");
            iWriter.print(iconSrc);
            iWriter.print("' alt='");
            if (tooltip != null) {
                iWriter.print(HtmlUtils.encode2HTML(tooltip));
            }
            iWriter.print("'/>");
        }
        iWriter.print(HtmlUtils.encode2HTML(title));
        if (isHyperLink || showSubMenu) {
            iWriter.print("</a>");
        } else {
            iWriter.print("</span>");
        }
        if (showSubMenu) {
            SubMenuLinkRenderer subMenuLinkRenderer = new SubMenuLinkRenderer(iLinkRenderer);
            iWriter.print("<ul>");
            for (int i = 0; i < this._xmlnode_1_unb_Items.length; ++i) {
                this._xmlnode_1_unb_Items[i].render(iRequest, iResponse, subMenuLinkRenderer);
            }
            iWriter.print("</ul>");
        }
        iWriter.println("</li>");
    }

    private static class SubMenuLinkRenderer
    implements ILinkHrefRenderer {
        private ILinkHrefRenderer parent;

        public SubMenuLinkRenderer(ILinkHrefRenderer parent) {
            this.parent = parent;
        }

        public boolean isEnabled(HttpServletRequest request) {
            return this.parent == null ? true : this.parent.isEnabled(request);
        }

        public void renderHref(HttpServletRequest request, HttpServletResponse response, String href) throws Exception {
            PrintWriter iWriter = response.getWriter();
            if (this.parent == null) {
                iWriter.print(" onfocus='Menu_focus(this)' onblur='Menu_blur(this)'");
                iWriter.print(" href='");
                iWriter.print(href);
                iWriter.print("'");
            } else {
                if (!(this.parent instanceof SubMenuLinkRenderer)) {
                    iWriter.print(" onfocus='Menu_focus(this)' onblur='Menu_blur(this)'");
                }
                this.parent.renderHref(request, response, href);
            }
        }
    }
}

