/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.tab;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.tab.ITabs;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPage;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPageRenderingContext;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicTabs
extends BaseBeanProvider
implements IXmlObject,
ITabs,
IBeanProvider,
IIdentifiable {
    private TabPage _xmlancestor_TabPage;
    private String _xmlattr_opt_ItemBeanName = "$tab";
    private String _xmlattr_opt_CssClass;
    private IBinding _xmlnode_req_Items;
    private IBinding _xmlnode_req_ID;
    private IMessage _xmlnode_req_Title;
    private IImage _xmlnode_opt_Icon;
    private IBoolExpr _xmlnode_opt_Visible;
    private IView[] _xmlcollect_1_unb_Views;
    private IBinding[] _xmlnode_0_unb_OnPreRender;
    private Type itemType;
    private Class itemClass;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "DynTab_" + this._xmlnode_req_ID.getID();
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Items != null && !this._xmlnode_req_Items.hasErrors()) {
            this.itemClass = ReflectionHelper.getVectorElementClass(this._xmlnode_req_Items.getGenericType());
            this.itemType = ReflectionHelper.getVectorElementType(this._xmlnode_req_Items.getGenericType());
            if (this.itemClass == null) {
                iErrors.logMessage((IXmlObject)this, "Items", 1, "Bound items must be vector data.");
            }
        }
    }

    private boolean isVisible(HttpServletRequest iRequest) {
        if (this._xmlnode_opt_Visible == null) {
            return true;
        }
        return this._xmlnode_opt_Visible.eval(iRequest);
    }

    public void declareTabs(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception {
        List items = ReflectionHelper.obj2List(this._xmlnode_req_Items.invoke(iRequest));
        if (items == null || items.isEmpty()) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            iRequest.setAttribute(this._xmlattr_opt_ItemBeanName, items.get(i));
            String id = String.valueOf(this._xmlnode_req_ID.invoke(iRequest));
            boolean visible = this._xmlnode_opt_Visible == null || this._xmlnode_opt_Visible.eval(iRequest);
            boolean enabled = true;
            iContext.addTab(this, id, visible, enabled, items.get(i));
        }
    }

    public void preRender(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception {
        int i;
        iRequest.setAttribute(this._xmlattr_opt_ItemBeanName, iContext.getSelectedTab().getAttached());
        if (this._xmlnode_0_unb_OnPreRender != null) {
            for (i = 0; i < this._xmlnode_0_unb_OnPreRender.length; ++i) {
                this._xmlnode_0_unb_OnPreRender[i].invoke(iRequest);
            }
        }
        for (i = 0; i < this._xmlcollect_1_unb_Views.length; ++i) {
            this._xmlcollect_1_unb_Views[i].preRender(iRequest);
        }
    }

    public void renderTabs(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        List<TabPageRenderingContext.TabDef> tabs = iContext.getTabsByProvider(this);
        for (int i = 0; i < tabs.size(); ++i) {
            TabPageRenderingContext.TabDef renderingTab = tabs.get(i);
            if (!renderingTab.isVisible()) continue;
            iRequest.setAttribute(this._xmlattr_opt_ItemBeanName, renderingTab.getAttached());
            String title = this._xmlnode_req_Title.getMessage(iRequest);
            String iconSrc = this._xmlnode_opt_Icon == null ? null : this._xmlnode_opt_Icon.getImage(iRequest);
            iWriter.print("<li");
            if (this._xmlattr_opt_CssClass != null) {
                iWriter.print(" class='");
                iWriter.print(this._xmlattr_opt_CssClass);
                iWriter.print("'");
            }
            iWriter.print(">");
            if (renderingTab.getId().equals(iContext.getSelectedTabId())) {
                int hLevel = HeadingUtils.getLevel(iRequest);
                HeadingUtils.incrLevel(iRequest);
                iWriter.print("<h");
                iWriter.print(String.valueOf(hLevel));
                iWriter.print(" class='Selected'>");
                if (iconSrc != null) {
                    iWriter.print("<img src='");
                    iWriter.print(iconSrc);
                    iWriter.print("' alt='");
                    iWriter.print("'/>");
                }
                iWriter.print(HtmlUtils.encode2HTML(title));
                iWriter.print("</h");
                iWriter.print(String.valueOf(hLevel));
                iWriter.print(">");
            } else if (!renderingTab.isEnabled()) {
                iWriter.print("<span class='Disabled'>");
                if (iconSrc != null) {
                    iWriter.print("<img src='");
                    iWriter.print(iconSrc);
                    iWriter.print("' alt='");
                    iWriter.print("'/>");
                }
                iWriter.print(HtmlUtils.encode2HTML(title));
                iWriter.print("</span>");
            } else {
                iWriter.print("<a href='");
                BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
                url.setParameter(iContext.getTabParamName(), renderingTab.getId());
                iWriter.print(url.toUrl(iRequest.getCharacterEncoding(), true));
                iWriter.print("'>");
                if (iconSrc != null) {
                    iWriter.print("<img src='");
                    iWriter.print(iconSrc);
                    iWriter.print("' alt='");
                    iWriter.print("'/>");
                }
                iWriter.print(HtmlUtils.encode2HTML(title));
                iWriter.print("</a>");
            }
            iWriter.println("</li>");
        }
    }

    public void renderContent(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception {
        for (int i = 0; i < this._xmlcollect_1_unb_Views.length; ++i) {
            this._xmlcollect_1_unb_Views[i].render(iRequest, iResponse);
        }
        HeadingUtils.decrLevel(iRequest);
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            if (this.itemClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemClass;
        }
        return this.getParentBeanType(iName);
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            if (this.itemType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this.itemType;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this._xmlattr_opt_ItemBeanName.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return this.getParentBeanValue(iRequest, iName);
    }
}

