/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.tab;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.tab.ITabs;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPage;
import com.ebm_ws.infra.bricks.components.base.html.tab.TabPageRenderingContext;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HeadingUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Tab
implements IXmlObject,
ITabs,
IIdentifiable {
    private String _xmlattr_req_ID;
    private String _xmlattr_opt_CssClass;
    private TabPage _xmlancestor_TabPage;
    private IMessage _xmlnode_req_Title;
    private IImage _xmlnode_opt_Icon;
    private IBoolExpr _xmlnode_opt_Visible;
    private IView[] _xmlcollect_1_unb_Views;
    private IBinding[] _xmlnode_0_unb_OnPreRender;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "Tab_" + this._xmlattr_req_ID;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    private boolean isVisible(HttpServletRequest iRequest) {
        if (this._xmlnode_opt_Visible == null) {
            return true;
        }
        return this._xmlnode_opt_Visible.eval(iRequest);
    }

    public void declareTabs(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception {
        iContext.addTab(this, this._xmlattr_req_ID, this.isVisible(iRequest), true, null);
    }

    public void preRender(HttpServletRequest iRequest, TabPageRenderingContext iContext) throws Exception {
        int i;
        if (this._xmlnode_0_unb_OnPreRender != null) {
            for (i = 0; i < this._xmlnode_0_unb_OnPreRender.length; ++i) {
                this._xmlnode_0_unb_OnPreRender[i].invoke(iRequest);
            }
        }
        for (i = 0; i < this._xmlcollect_1_unb_Views.length; ++i) {
            this._xmlcollect_1_unb_Views[i].preRender(iRequest);
        }
    }

    public void renderTabs(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception {
        TabPageRenderingContext.TabDef renderingTab = iContext.getTab(this._xmlattr_req_ID);
        if (!renderingTab.isVisible()) {
            return;
        }
        String title = this._xmlnode_req_Title.getMessage(iRequest);
        String iconSrc = this._xmlnode_opt_Icon == null ? null : this._xmlnode_opt_Icon.getImage(iRequest);
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.print("<li");
        if (this._xmlattr_opt_CssClass != null) {
            iWriter.print(" class='");
            iWriter.print(this._xmlattr_opt_CssClass);
            iWriter.print("'");
        }
        iWriter.print(">");
        if (renderingTab.getId().equals(iContext.getSelectedTabId())) {
            int hLevel = HeadingUtils.getLevel(iRequest);
            HeadingUtils.incrLevel(iRequest);
            iWriter.print("<h");
            iWriter.print(String.valueOf(hLevel));
            iWriter.print(" class='Selected'>");
            if (iconSrc != null) {
                iWriter.print("<img src='");
                iWriter.print(iconSrc);
                iWriter.print("' alt='");
                iWriter.print("'/>");
            }
            iWriter.print(HtmlUtils.encode2HTML(title));
            iWriter.print("</h");
            iWriter.print(String.valueOf(hLevel));
            iWriter.print(">");
        } else if (!renderingTab.isEnabled()) {
            iWriter.print("<span class='Disabled'>");
            if (iconSrc != null) {
                iWriter.print("<img src='");
                iWriter.print(iconSrc);
                iWriter.print("' alt='");
                iWriter.print("'/>");
            }
            iWriter.print(HtmlUtils.encode2HTML(title));
            iWriter.print("</span>");
        } else {
            iWriter.print("<a href='");
            BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
            url.setParameter(iContext.getTabParamName(), renderingTab.getId());
            iWriter.print(url.toUrl(iRequest.getCharacterEncoding(), true));
            iWriter.print("'>");
            if (iconSrc != null) {
                iWriter.print("<img src='");
                iWriter.print(iconSrc);
                iWriter.print("' alt='");
                iWriter.print("'/>");
            }
            iWriter.print(HtmlUtils.encode2HTML(title));
            iWriter.print("</a>");
        }
        iWriter.println("</li>");
    }

    public void renderContent(HttpServletRequest iRequest, HttpServletResponse iResponse, TabPageRenderingContext iContext) throws Exception {
        for (int i = 0; i < this._xmlcollect_1_unb_Views.length; ++i) {
            this._xmlcollect_1_unb_Views[i].render(iRequest, iResponse);
        }
        HeadingUtils.decrLevel(iRequest);
    }
}

