/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.tab;

import com.ebm_ws.infra.bricks.components.base.html.tab.ITabs;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabPageRenderingContext {
    private List<TabDef> tabs = new ArrayList<TabDef>();
    private TabDef selectedTab;
    private String tabParamName;

    public TabPageRenderingContext(String tabParamName) {
        this.tabParamName = tabParamName;
    }

    public String getTabParamName() {
        return this.tabParamName;
    }

    public String getSelectedTabId() {
        if (this.selectedTab == null) {
            return null;
        }
        return this.selectedTab.getId();
    }

    public TabDef getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(TabDef selectedTab) {
        this.selectedTab = selectedTab;
    }

    public boolean hasVisibleTabs() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabDef tab = this.tabs.get(i);
            if (!tab.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void addTab(ITabs provider, String id, boolean visible, boolean enabled, Object attached) {
        this.tabs.add(new TabDef(provider, id, visible, enabled, attached));
    }

    public List<TabDef> getTabsByProvider(ITabs iProvider) {
        ArrayList<TabDef> ret = new ArrayList<TabDef>();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (this.tabs.get(i).getProvider() != iProvider) continue;
            ret.add(this.tabs.get(i));
        }
        return ret;
    }

    public TabDef getTab(String id) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get(i).getId().equals(id)) continue;
            return this.tabs.get(i);
        }
        return null;
    }

    public TabDef getFirstDisplayableTab() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabDef tab = this.tabs.get(i);
            if (!tab.isEnabled() || !tab.isVisible()) continue;
            return this.tabs.get(i);
        }
        return null;
    }

    public static class TabDef {
        private ITabs provider;
        private String id;
        private boolean visible;
        private boolean enabled;
        private Object attached;

        public TabDef(ITabs provider, String id, boolean visible, boolean enabled, Object attached) {
            this.provider = provider;
            this.id = id;
            this.visible = visible;
            this.enabled = enabled;
            this.attached = attached;
        }

        public Object getAttached() {
            return this.attached;
        }

        public ITabs getProvider() {
            return this.provider;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getId() {
            return this.id;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

