/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.components.base.boolexpr.IBoolExpr;
import com.ebm_ws.infra.bricks.components.base.enums.Alignment;
import com.ebm_ws.infra.bricks.components.base.html.table.IColumn;
import com.ebm_ws.infra.bricks.components.base.html.table.IFilter;
import com.ebm_ws.infra.bricks.components.base.html.table.ISorter;
import com.ebm_ws.infra.bricks.components.base.html.table.Table;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.table.TableRenderingContext;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseColumn
implements IColumn,
IXmlObject {
    private Table _xmlancestor_Table;
    private Alignment _xmlattr_opt_Alignment = Alignment.Left;
    private IMessage _xmlnode_req_Title;
    private ISorter _xmlnode_opt_Sort;
    private IFilter _xmlnode_opt_Filter;
    private IBoolExpr _xmlnode_opt_Visible;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    public Alignment getAligment() {
        return this._xmlattr_opt_Alignment;
    }

    public boolean isVisible(HttpServletRequest iRequest) {
        if (this._xmlnode_opt_Visible == null) {
            return true;
        }
        return this._xmlnode_opt_Visible.eval(iRequest);
    }

    public IFilter getFilter() {
        return this._xmlnode_opt_Filter;
    }

    public ISorter getSorter() {
        return this._xmlnode_opt_Sort;
    }

    public String getTitle(HttpServletRequest iRequest) {
        return this._xmlnode_req_Title.getMessage(iRequest);
    }

    public void renderHeader(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, ILinkHrefRenderer iLinkRenderer, int icol) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        writer.print("<th");
        writer.print(" scope=col");
        if (this.getAligment() == Alignment.Left) {
            writer.print(" align=left");
        } else if (this.getAligment() == Alignment.Right) {
            writer.print(" align=right");
        } else if (this.getAligment() == Alignment.Center) {
            writer.print(" align=center");
        }
        writer.print(">");
        if (this.getSorter() != null) {
            int sortcol = icol + 1;
            if (icol == context.getSortColumn() && context.getSortDirection()) {
                sortcol = -sortcol;
            }
            BricksUrlBuilder sorturl = BricksUrlBuilder.copyFromRequest(iRequest, true);
            sorturl.removeParameter(this._xmlancestor_Table.getID() + ".page");
            sorturl.setParameter(this._xmlancestor_Table.getID() + ".sort", String.valueOf(sortcol));
            writer.print("<a");
            if (iLinkRenderer != null) {
                iLinkRenderer.renderHref(iRequest, iResponse, sorturl.toUrl(iRequest.getCharacterEncoding(), true));
            } else {
                writer.print(" href='");
                writer.print(sorturl.toUrl(iRequest.getCharacterEncoding(), true));
                writer.print("'");
            }
            writer.print(" title='");
            if (sortcol < 0) {
                writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.sortdesc")));
            } else {
                writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.sortasc")));
            }
            writer.print("'");
            if (context.getSortColumn() == icol) {
                if (context.getSortDirection()) {
                    writer.print(" class='sortedasc'");
                } else {
                    writer.print(" class='sorteddesc'");
                }
            }
            writer.print(">");
        } else {
            writer.print("<span>");
        }
        writer.print(HtmlUtils.encode2HTML(this._xmlnode_req_Title.getMessage(iRequest)));
        if (this.getSorter() != null) {
            writer.print("</a>");
        } else {
            writer.print("</span>");
        }
        if (this._xmlnode_opt_Filter != null) {
            writer.print("<div class=filter>");
            this.getFilter().render(iRequest, iResponse, context, iLinkRenderer, icol);
            writer.print("</div>");
        }
        writer.println("</th>");
    }

    public void renderCell(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        writer.print("<td");
        if (this.getAligment() == Alignment.Right) {
            writer.print(" align=right");
        } else if (this.getAligment() == Alignment.Center) {
            writer.print(" align=center");
        }
        writer.print(">");
        this.renderCellContent(iRequest, iResponse, icol, iRowObject);
        writer.println("</td>");
    }
}

