/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.components.base.html.item.DisplayableItem;
import com.ebm_ws.infra.bricks.components.base.html.item.IItemsProvider;
import com.ebm_ws.infra.bricks.components.base.html.table.IColumn;
import com.ebm_ws.infra.bricks.components.base.html.table.IFilter;
import com.ebm_ws.infra.bricks.components.base.html.table.Table;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.table.TableRenderingContext;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboFilter
implements IXmlObject,
IFilter {
    private static String NO_FILTER_VAL = "";
    private Table _xmlancestor_table;
    private IColumn _xmlancestor_col;
    private IItemsProvider _xmlnode_req_Items;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlnode_req_Items != null) {
            Class itemType = this._xmlnode_req_Items.getItemValueType();
            Class cellType = this._xmlancestor_col.getCellType();
            if (itemType != null && cellType != null && !ReflectionHelper.isAssignable(cellType, itemType)) {
                iErrors.logMessage((IXmlObject)this, "Items", 3, "Filter type (" + itemType + ") incompatible with cell type (" + cellType + ")");
            }
        }
    }

    public Object compileFilter(HttpServletRequest iRequest, String iFilter) throws Exception {
        if (iFilter == null || iFilter.equals(NO_FILTER_VAL)) {
            return null;
        }
        return iFilter;
    }

    public boolean passFilter(HttpServletRequest iRequest, Object iCompiledFilter, Object iRowObject) throws Exception {
        String filter = (String)iCompiledFilter;
        Object cellVal = this._xmlancestor_col.getCellValue(iRequest, iRowObject);
        if (cellVal == null) {
            return false;
        }
        return filter.equals(String.valueOf(cellVal));
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse, TableRenderingContext context, ILinkHrefRenderer iLinkRenderer, int icol) throws Exception {
        String currentFilter = context.getFilter(icol);
        if (currentFilter == null) {
            currentFilter = NO_FILTER_VAL;
        }
        DisplayableItem[] items = this._xmlnode_req_Items.getItems(iRequest);
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.print("<select");
        iWriter.print(" name='");
        iWriter.print(this._xmlancestor_table.getID() + ".filter." + icol);
        iWriter.print("'");
        iWriter.print(" onchange=\"document.forms['" + this._xmlancestor_table.getFormName() + "'].submit();\"");
        iWriter.println(">");
        iWriter.print("<option");
        iWriter.print(" value='" + NO_FILTER_VAL + "'");
        if (currentFilter.equals(NO_FILTER_VAL)) {
            iWriter.print(" selected='selected'");
        }
        iWriter.print(">");
        iWriter.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.filter.select_all")));
        iWriter.println("</option>");
        for (int i = 0; i < items.length; ++i) {
            String valStr = String.valueOf(items[i].getValue());
            iWriter.print("<option");
            iWriter.print(" value='");
            iWriter.print(valStr);
            iWriter.print("'");
            if (currentFilter.equals(valStr)) {
                iWriter.print(" selected='selected'");
            }
            iWriter.print(">");
            iWriter.print(HtmlUtils.encode2HTML(items[i].getText()));
            iWriter.println("</option>");
        }
        iWriter.println("</select>");
    }
}

