/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.DateType;
import com.ebm_ws.infra.bricks.components.base.html.table.BaseColumn;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DateColumn
extends BaseColumn {
    private DateType _xmlattr_opt_Type = DateType.DateOnly;
    private IBinding _xmlnode_req_Date;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        super.checkThisNode(iValidSupport, iErrors);
        if (this._xmlnode_req_Date != null && !this._xmlnode_req_Date.hasErrors() && !ReflectionHelper.isDate(this._xmlnode_req_Date.getType())) {
            iErrors.logMessage((IXmlObject)this, "Date", 1, "The Date binding has to return a value of type java.util.Date or java.util.Calendar");
        }
    }

    public Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception {
        return ReflectionHelper.obj2Date(this._xmlnode_req_Date.invoke(iRequest));
    }

    public String getCellText(HttpServletRequest iRequest, Object iRowObject) throws Exception {
        Date date = ReflectionHelper.obj2Date(this._xmlnode_req_Date.invoke(iRequest));
        if (date == null) {
            return null;
        }
        BricksSession session = BricksSession.getSession(iRequest);
        DateFormat format = DateType.getOutputFormat(session.getLocaleConfig(), this._xmlattr_opt_Type);
        return format.format(date);
    }

    public void renderCellContent(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        Date date = ReflectionHelper.obj2Date(this._xmlnode_req_Date.invoke(iRequest));
        if (date == null) {
            writer.print("&nbsp;");
            return;
        }
        BricksSession session = BricksSession.getSession(iRequest);
        DateFormat format = DateType.getOutputFormat(session.getLocaleConfig(), this._xmlattr_opt_Type);
        writer.print(HtmlUtils.encode2HTML(format.format(date)));
    }

    public Class getCellType() {
        if (this._xmlnode_req_Date == null) {
            return null;
        }
        return this._xmlnode_req_Date.getType();
    }
}

