/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.enums.TableStyle;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.menu.IMenuItem;
import com.ebm_ws.infra.bricks.components.base.html.table.IColumn;
import com.ebm_ws.infra.bricks.components.base.html.table.ISorter;
import com.ebm_ws.infra.bricks.components.base.html.table.SelectionBindings;
import com.ebm_ws.infra.bricks.components.base.html.table.TableRenderingContextImpl;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.components.interfaces.ILinkHrefRenderer;
import com.ebm_ws.infra.bricks.util.BricksMessages;
import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.util.RenderingContext;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Table
extends BaseBeanProvider
implements IView,
IXmlObject,
IIdentifiable,
IBeanProvider,
ILinkHrefRenderer {
    private Application _xmlroot;
    private String _xmlattr_req_ID;
    private String _xmlattr_opt_CssClass = "Table";
    private boolean _xmlattr_opt_SortAndPaginateLocaly = false;
    private String _xmlattr_opt_RowBeanName = "$row";
    private TableStyle _xmlattr_opt_Style = TableStyle.Table;
    private IMessage _xmlnode_opt_Title;
    private IBinding _xmlnode_opt_ResultsPerPage;
    private IBinding _xmlnode_req_RowsData;
    private SelectionBindings _xmlnode_opt_Selection;
    private IView[] _xmlnode_0_unb_DetailsView;
    private IMenuItem[] _xmlnode_0_unb_Toolbar;
    private IColumn[] _xmlnode_1_unb_Columns;
    private Class _itemClass;
    private Type _itemType;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "Table_" + this._xmlattr_req_ID;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (!(this._xmlnode_opt_ResultsPerPage == null || this._xmlnode_opt_ResultsPerPage.hasErrors() || Integer.TYPE.isAssignableFrom(this._xmlnode_opt_ResultsPerPage.getType()) || Integer.class.isAssignableFrom(this._xmlnode_opt_ResultsPerPage.getType()))) {
            iErrors.logMessage((IXmlObject)this, "ResultsPerPage", 1, "ResultsPerPage binding must return either an int or Integer.");
        }
        if (this._xmlnode_req_RowsData != null && !this._xmlnode_req_RowsData.hasErrors()) {
            this._itemType = ReflectionHelper.getVectorElementType(this._xmlnode_req_RowsData.getGenericType());
            this._itemClass = ReflectionHelper.getVectorElementClass(this._xmlnode_req_RowsData.getGenericType());
            if (this._itemClass == null) {
                iErrors.logMessage((IXmlObject)this, "Data", 1, "Data binding is not of vector type.");
            }
        }
        if (this._xmlattr_opt_SortAndPaginateLocaly) {
            iErrors.logMessage((IXmlObject)this, "SortAndPaginateLocaly", 5, "Have table handle sort and pagination localy may overwhelm server resources.");
        }
        if (this._xmlroot.registerRequestHandler(this.getPathID(), this) != null) {
            iErrors.logMessage((IXmlObject)this, "ID", 5, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        }
    }

    public String getID() {
        return this._xmlattr_req_ID;
    }

    public String getFormName() {
        return "form." + this._xmlattr_req_ID;
    }

    public String getRowBeanName() {
        return this._xmlattr_opt_RowBeanName;
    }

    public IColumn[] getColumns() {
        return this._xmlnode_1_unb_Columns;
    }

    public void submit(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        String redirectUrl;
        int i;
        if (this._xmlnode_opt_Selection != null) {
            String[] values = iRequest.getParameterValues("selection");
            if (values == null) {
                values = new String[]{};
            }
            ArrayList<Object> selection = new ArrayList<Object>();
            if (ReflectionHelper.isIntegerLike(this._xmlnode_opt_Selection.getIDType())) {
                for (i = 0; i < values.length; ++i) {
                    selection.add(ReflectionHelper.parse2Type(values[i], this._xmlnode_opt_Selection.getIDType()));
                }
            } else {
                for (i = 0; i < values.length; ++i) {
                    selection.add(values[i]);
                }
            }
            this._xmlnode_opt_Selection._xmlnode_req_SelectedIDs.setValue(iRequest, ReflectionHelper.vect2obj(selection, this._xmlnode_opt_Selection._xmlnode_req_SelectedIDs.getType()));
        }
        if ((redirectUrl = iRequest.getParameter("redirect_href")) != null && redirectUrl.length() > 0) {
            iResponse.sendRedirect(redirectUrl);
            return;
        }
        BricksUrlBuilder url = BricksUrlBuilder.copyFromRequest(iRequest, true);
        for (i = 0; i < this._xmlnode_1_unb_Columns.length; ++i) {
            if (this._xmlnode_1_unb_Columns[i].getFilter() == null) continue;
            String filterParam = this.getID() + ".filter." + i;
            String filter = iRequest.getParameter(filterParam);
            if (filter != null) {
                filter = filter.trim();
            }
            if (filter != null && filter.length() > 0) {
                url.setParameter(filterParam, filter);
                continue;
            }
            url.removeParameter(filterParam);
        }
        iResponse.sendRedirect(url.toUrl(iResponse.getCharacterEncoding(), false));
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        String exp;
        String sort;
        String pageStr;
        TableRenderingContextImpl context = new TableRenderingContextImpl();
        context.columnsVisibility = new boolean[this._xmlnode_1_unb_Columns.length];
        context.columnsCount = 0;
        for (int i = 0; i < this._xmlnode_1_unb_Columns.length; ++i) {
            context.columnsVisibility[i] = this._xmlnode_1_unb_Columns[i].isVisible(iRequest);
            if (!context.columnsVisibility[i]) continue;
            ++context.columnsCount;
        }
        context.columns = this._xmlnode_1_unb_Columns;
        if (this._xmlnode_opt_ResultsPerPage != null) {
            context.setRowsPerPage((Integer)this._xmlnode_opt_ResultsPerPage.invoke(iRequest));
        }
        if (context.getRowsPerPage() != Integer.MAX_VALUE && (pageStr = iRequest.getParameter(this._xmlattr_req_ID + ".page")) != null) {
            context.setPage(Integer.parseInt(pageStr));
        }
        if ((sort = iRequest.getParameter(this._xmlattr_req_ID + ".sort")) != null) {
            int sortColAndDir = Integer.parseInt(sort);
            context.sortColumn = Math.abs(sortColAndDir) - 1;
            context.sortDirection = sortColAndDir > 0;
        }
        for (int i = 0; i < this._xmlnode_1_unb_Columns.length; ++i) {
            if (!context.columnsVisibility[i] || this._xmlnode_1_unb_Columns[i].getFilter() == null) continue;
            context.hasFilters = true;
            String filter = iRequest.getParameter(this.getID() + ".filter." + i);
            if (filter == null || (filter = filter.trim()).length() <= 0) continue;
            if (context.columnFilters == null) {
                context.columnFilters = new String[this._xmlnode_1_unb_Columns.length];
            }
            context.columnFilters[i] = filter;
        }
        iRequest.setAttribute("$context", (Object)context);
        List data = ReflectionHelper.obj2List(this._xmlnode_req_RowsData.invoke(iRequest));
        if (this._xmlattr_opt_SortAndPaginateLocaly) {
            data = this.sortAndPaginate(iRequest, data, context);
        }
        if (this._xmlnode_0_unb_DetailsView != null && this._xmlnode_0_unb_DetailsView.length > 0 && (exp = iRequest.getParameter("_" + this._xmlattr_req_ID + ".exp")) != null) {
            int expanded = Integer.parseInt(exp);
            iRequest.setAttribute(this._xmlattr_opt_RowBeanName, data.get(expanded));
            for (int i = 0; i < this._xmlnode_0_unb_DetailsView.length; ++i) {
                this._xmlnode_0_unb_DetailsView[i].preRender(iRequest);
            }
        }
        iRequest.removeAttribute("$context");
        RenderingContext.get(iRequest).put(this, "ctx", context);
        if (data != null) {
            RenderingContext.get(iRequest).put(this, "data", data);
        }
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        Object[] args;
        String exp;
        int nbRowsDisplayed;
        List data = (List)RenderingContext.get(iRequest).get(this, "data");
        TableRenderingContextImpl context = (TableRenderingContextImpl)RenderingContext.get(iRequest).get(this, "ctx");
        iRequest.setAttribute("$context", (Object)context);
        boolean hasNavigationBar = false;
        int nbOfPages = 0;
        if (context.rowsCount >= 0) {
            nbOfPages = (context.rowsCount - 1) / context.getRowsPerPage() + 1;
        } else {
            nbOfPages = context.getPage() + 1;
            if (data != null && data.size() >= context.getRowsPerPage()) {
                ++nbOfPages;
            }
        }
        if (nbOfPages > 1) {
            hasNavigationBar = true;
        }
        int n = nbRowsDisplayed = data == null ? 0 : data.size();
        if (context.getRowsPerPage() > 0 && nbRowsDisplayed > context.getRowsPerPage()) {
            nbRowsDisplayed = context.getRowsPerPage();
        }
        int nbToolCols = 0;
        int nbColsDisplayed = context.columnsCount;
        if (this._xmlnode_0_unb_DetailsView != null) {
            ++nbToolCols;
        }
        if (this._xmlnode_opt_Selection != null) {
            ++nbToolCols;
        }
        boolean hasForm = false;
        if (this._xmlnode_opt_Selection != null) {
            hasForm = true;
        }
        if (context.hasFilters()) {
            hasForm = true;
        }
        ArrayList selectedIds = null;
        if (this._xmlnode_opt_Selection != null && (selectedIds = ReflectionHelper.obj2List(this._xmlnode_opt_Selection._xmlnode_req_SelectedIDs.invoke(iRequest))) != null) {
            selectedIds = new ArrayList(selectedIds);
        }
        int expanded = -1;
        if (this._xmlnode_0_unb_DetailsView != null && (exp = iRequest.getParameter("_" + this._xmlattr_req_ID + ".exp")) != null) {
            expanded = Integer.parseInt(exp);
        }
        PrintWriter writer = iResponse.getWriter();
        if (hasForm) {
            HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Table.js");
            writer.print("<form name='" + this.getFormName() + "' method='post' action='");
            BricksUrlBuilder formActionUrl = BricksUrlBuilder.copyFromRequest(iRequest, true);
            formActionUrl.removeParameter(this.getID() + ".page");
            for (int i = 0; i < this._xmlnode_1_unb_Columns.length; ++i) {
                if (this._xmlnode_1_unb_Columns[i].getFilter() == null) continue;
                formActionUrl.removeParameter(this.getID() + ".filter." + i);
            }
            writer.print(formActionUrl.toUrl(iRequest.getCharacterEncoding(), true));
            writer.println("'>");
            writer.print("<input type='hidden' name='");
            writer.print(this._xmlroot.getHandlerParamName());
            writer.print("'");
            writer.print(" value='");
            writer.print(this._xmlroot.getHandlerParamValue(this, "submit"));
            writer.print("'");
            writer.println("/>");
            writer.println("<input type='hidden' name='redirect_href'/>");
        }
        writer.print("<table class='");
        writer.print(this._xmlattr_opt_CssClass);
        writer.print("'");
        writer.print(" id='");
        writer.print(this._xmlattr_req_ID);
        writer.println("'>");
        if (this._xmlnode_opt_Title != null) {
            writer.print("<caption>");
            writer.print(HtmlUtils.encode2HTML(this._xmlnode_opt_Title.getMessage(iRequest)));
            writer.println("</caption>");
        }
        writer.println("<thead>");
        if (this._xmlnode_0_unb_Toolbar != null) {
            writer.println("<tr class='toolbar'>");
            writer.print("<th colspan='");
            writer.print(String.valueOf(nbToolCols + nbColsDisplayed));
            writer.println("'>");
            writer.print("<div class=Buttons>");
            writer.print("<ul>");
            for (int i = 0; i < this._xmlnode_0_unb_Toolbar.length; ++i) {
                this._xmlnode_0_unb_Toolbar[i].render(iRequest, iResponse, hasForm ? this : null);
            }
            writer.println("</ul>");
            writer.print("</div>");
            writer.println("</th>");
            writer.println("</tr>");
        }
        writer.println("<tr class='navigation'>");
        writer.print("<th colspan='");
        writer.print(String.valueOf(nbToolCols + nbColsDisplayed));
        writer.println("'>");
        writer.print("<div class='range'>");
        if (context.rowsCount == 0 || nbRowsDisplayed == 0) {
            writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.no_data")));
        } else if (context.hasPagination()) {
            if (context.rowsCount > 0) {
                args = new Object[]{new Integer(context.getFirstIndex() + 1), new Integer(context.getFirstIndex() + nbRowsDisplayed), new Integer(context.rowsCount)};
                writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.nbrows_known", args)));
            } else {
                args = new Object[]{new Integer(context.getFirstIndex() + 1), new Integer(context.getFirstIndex() + nbRowsDisplayed)};
                writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.nbrows_unknown", args)));
            }
        } else {
            args = new Object[]{new Integer(nbRowsDisplayed)};
            writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.range.no_pagination", args)));
        }
        writer.print("</div>");
        if (nbOfPages > 1) {
            boolean showPrevLink = context.getPage() > 0;
            boolean showNextLink = context.getPage() < nbOfPages - 1;
            writer.print("<div class='pagelinks'>");
            writer.print("&nbsp;");
            if (showPrevLink) {
                BricksUrlBuilder prevurl = BricksUrlBuilder.copyFromRequest(iRequest, true);
                prevurl.setParameter(this._xmlattr_req_ID + ".page", String.valueOf(context.getPage() - 1));
                writer.print("<a class=prev");
                this.renderHref(iRequest, iResponse, prevurl.toUrl(iRequest.getCharacterEncoding(), true));
                writer.print(">");
            } else {
                writer.print("<span class=prevd>");
            }
            writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.previous")));
            if (showPrevLink) {
                writer.print("</a>");
            } else {
                writer.print("</span>");
            }
            for (int ipage = 0; ipage < nbOfPages; ++ipage) {
                writer.print("&nbsp;");
                if (ipage != context.getPage()) {
                    BricksUrlBuilder pageurl = BricksUrlBuilder.copyFromRequest(iRequest, true);
                    pageurl.setParameter(this._xmlattr_req_ID + ".page", String.valueOf(ipage));
                    writer.print("<a");
                    this.renderHref(iRequest, iResponse, pageurl.toUrl(iRequest.getCharacterEncoding(), true));
                    writer.print(">");
                } else {
                    writer.print("<span>");
                }
                writer.print(String.valueOf(ipage + 1));
                if (ipage != context.getPage()) {
                    writer.print("</a>");
                    continue;
                }
                writer.print("</span>");
            }
            writer.print("&nbsp;");
            if (showNextLink) {
                BricksUrlBuilder nexturl = BricksUrlBuilder.copyFromRequest(iRequest, true);
                nexturl.setParameter(this._xmlattr_req_ID + ".page", String.valueOf(context.getPage() + 1));
                writer.print("<a class=next");
                this.renderHref(iRequest, iResponse, nexturl.toUrl(iRequest.getCharacterEncoding(), true));
                writer.print(">");
            } else {
                writer.print("<span class=nextd>");
            }
            writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.next")));
            if (showNextLink) {
                writer.print("</a>");
            } else {
                writer.print("</span>");
            }
            writer.print("</div>");
        }
        writer.println("</th>");
        writer.println("</tr>");
        writer.println("<tr class='headers'>");
        if (this._xmlnode_0_unb_DetailsView != null) {
            writer.println("<th id='" + this.getID() + "_details' class=Details>&nbsp;</th>");
        }
        if (this._xmlnode_opt_Selection != null) {
            writer.println("<th id='" + this.getID() + "_select' class=Select>&nbsp;</th>");
        }
        for (int icol = 0; icol < this._xmlnode_1_unb_Columns.length; ++icol) {
            if (!context.columnsVisibility[icol]) continue;
            this._xmlnode_1_unb_Columns[icol].renderHeader(iRequest, iResponse, context, hasForm ? this : null, icol);
        }
        writer.println("</tr>");
        writer.println("</thead>");
        writer.println("<tbody>");
        if (data == null || data.size() == 0) {
            writer.println("<tr>");
            writer.print("<td colspan=");
            writer.print(String.valueOf(nbToolCols + nbColsDisplayed));
            writer.print(">");
            writer.print(HtmlUtils.encode2HTML(BricksMessages.getMessage(iResponse.getLocale(), "table.nodata")));
            writer.println("</td>");
            writer.println("</tr>");
        } else {
            for (int irow = 0; irow < nbRowsDisplayed; ++irow) {
                iRequest.setAttribute(this._xmlattr_opt_RowBeanName, data.get(irow));
                writer.print("<tr class='");
                if (irow % 2 == 0) {
                    writer.print("even");
                } else {
                    writer.print("odd");
                }
                writer.println("'>");
                if (this._xmlnode_0_unb_DetailsView != null) {
                    writer.print("<td");
                    writer.print(" class=Details>");
                    if (irow == expanded) {
                        String collapseText = BricksMessages.getMessage(iResponse.getLocale(), "table.collapse");
                        BricksUrlBuilder collapseUrl = BricksUrlBuilder.copyFromRequest(iRequest, true);
                        writer.print("<a class=Expanded");
                        this.renderHref(iRequest, iResponse, collapseUrl.toUrl(iRequest.getCharacterEncoding(), true));
                        writer.print(" title='");
                        writer.print(HtmlUtils.encode2HTML(collapseText));
                        writer.print("'");
                        writer.print(">");
                        writer.print(HtmlUtils.encode2HTML(collapseText));
                        writer.print("</a>");
                    } else {
                        String expandText = BricksMessages.getMessage(iResponse.getLocale(), "table.expand");
                        BricksUrlBuilder expandUrl = BricksUrlBuilder.copyFromRequest(iRequest, true);
                        expandUrl.setParameter("_" + this.getID() + ".exp", String.valueOf(irow));
                        writer.print("<a class=Collasped");
                        this.renderHref(iRequest, iResponse, expandUrl.toUrl(iRequest.getCharacterEncoding(), true));
                        writer.print(" title='");
                        writer.print(HtmlUtils.encode2HTML(expandText));
                        writer.print("'");
                        writer.print(">");
                        writer.print(HtmlUtils.encode2HTML(expandText));
                        writer.print("</a>");
                    }
                    writer.println("</td>");
                }
                if (this._xmlnode_opt_Selection != null) {
                    int idx;
                    Object curId = this._xmlnode_opt_Selection._xmlnode_req_RowID.invoke(iRequest);
                    boolean selected = false;
                    if (selectedIds != null && (idx = selectedIds.indexOf(curId)) >= 0) {
                        selected = true;
                        selectedIds.remove(idx);
                    }
                    writer.print("<td");
                    writer.print(" class=Select>");
                    writer.print("<input type='checkbox' class='checkbox' name='selection'");
                    writer.print(" value='");
                    writer.print(String.valueOf(curId));
                    writer.print("'");
                    if (selected) {
                        writer.print(" checked='checked'");
                    }
                    writer.print("/>");
                    writer.println("</td>");
                }
                if (this._xmlattr_opt_Style == TableStyle.Paragraphs) {
                    writer.print("<td colspan='");
                    writer.print(String.valueOf(nbColsDisplayed));
                    writer.println("'>");
                }
                int iDisplayedCol = 0;
                for (int icol = 0; icol < this._xmlnode_1_unb_Columns.length; ++icol) {
                    if (!context.columnsVisibility[icol]) continue;
                    if (this._xmlattr_opt_Style == TableStyle.Table) {
                        this._xmlnode_1_unb_Columns[icol].renderCell(iRequest, iResponse, icol, data.get(irow));
                    } else {
                        if (iDisplayedCol > 0) {
                            writer.print(", ");
                        }
                        writer.print("<span class=title>");
                        writer.print(HtmlUtils.encode2HTML(this._xmlnode_1_unb_Columns[icol].getTitle(iRequest)));
                        writer.print(" :</span>");
                        writer.print(" ");
                        this._xmlnode_1_unb_Columns[icol].renderCellContent(iRequest, iResponse, icol, data.get(irow));
                    }
                    ++iDisplayedCol;
                }
                if (this._xmlattr_opt_Style == TableStyle.Paragraphs) {
                    writer.println("</td>");
                }
                writer.println("</tr>");
                if (this._xmlnode_0_unb_DetailsView == null || irow != expanded) continue;
                writer.print("<tr class='Details ");
                if (irow % 2 == 0) {
                    writer.print("even");
                } else {
                    writer.print("odd");
                }
                writer.println("'>");
                writer.print("<td class=Details>&nbsp;</td>");
                if (this._xmlnode_opt_Selection != null) {
                    writer.print("<td class=Select>&nbsp;</td>");
                }
                writer.print("<td class=DetailsView colspan=");
                writer.print(String.valueOf(nbColsDisplayed));
                writer.print(">");
                for (int i = 0; i < this._xmlnode_0_unb_DetailsView.length; ++i) {
                    this._xmlnode_0_unb_DetailsView[i].render(iRequest, iResponse);
                }
                writer.println("</td>");
                writer.println("</tr>");
            }
        }
        writer.println("</tbody>");
        writer.println("</table>");
        if (hasForm) {
            if (this._xmlnode_opt_Selection != null && selectedIds != null) {
                for (int i = 0; i < selectedIds.size(); ++i) {
                    writer.print("<input type='hidden' name='selection'");
                    writer.print(" value='");
                    writer.print(String.valueOf(selectedIds.get(i)));
                    writer.print("'");
                    writer.println("/>");
                }
            }
            writer.println("</form>");
        }
    }

    public boolean isEnabled(HttpServletRequest request) {
        return true;
    }

    public void renderHref(HttpServletRequest iRequest, HttpServletResponse iResponse, String iHref) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        if (this._xmlnode_opt_Selection == null) {
            writer.print(" href='");
            writer.print(iHref);
            writer.print("'");
        } else {
            writer.print(" href='javascript:void(0)' onclick=\"Table_submitAndNavigate('" + this.getFormName() + "', '" + iHref + "'); return false;\"");
        }
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_RowBeanName.equals(iName)) {
            if (this._itemClass == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this._itemClass;
        }
        if ("$context".equals(iName)) {
            return TableRenderingContextImpl.class;
        }
        return this.getParentBeanType(iName);
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        if (this._xmlattr_opt_RowBeanName.equals(iName)) {
            if (this._itemType == null) {
                throw new IBeanProvider.UnresolvedBeanError();
            }
            return this._itemType;
        }
        if ("$context".equals(iName)) {
            return TableRenderingContextImpl.class;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        if (this._xmlattr_opt_RowBeanName.equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        if ("$context".equals(iName)) {
            return iRequest.getAttribute(iName);
        }
        return this.getParentBeanValue(iRequest, iName);
    }

    public Object getCurrentRow(HttpServletRequest iRequest) {
        return iRequest.getAttribute(this._xmlattr_opt_RowBeanName);
    }

    private List sortAndPaginate(HttpServletRequest iRequest, List rowsData, TableRenderingContextImpl context) throws Exception {
        if (rowsData == null) {
            rowsData = new ArrayList<Object>();
        }
        if (context.getFilters() != null) {
            String[] filters = context.getFilters();
            Object[] compiledFilter = new Object[filters.length];
            for (int j = 0; j < filters.length; ++j) {
                if (filters[j] == null || context.getColumns()[j].getFilter() == null) continue;
                compiledFilter[j] = context.getColumns()[j].getFilter().compileFilter(iRequest, filters[j]);
            }
            ArrayList filtered = new ArrayList();
            for (int i = 0; i < rowsData.size(); ++i) {
                Object rowObj = rowsData.get(i);
                iRequest.setAttribute(this._xmlattr_opt_RowBeanName, rowObj);
                boolean passes = true;
                for (int j = 0; j < compiledFilter.length; ++j) {
                    if (compiledFilter[j] == null || context.getColumns()[j].getFilter().passFilter(iRequest, compiledFilter[j], rowObj)) continue;
                    passes = false;
                    break;
                }
                if (!passes) continue;
                filtered.add(rowObj);
            }
            rowsData = filtered;
        }
        if (context.hasSortedColumn()) {
            int i;
            SortableRow[] sortable = new SortableRow[rowsData.size()];
            for (i = 0; i < rowsData.size(); ++i) {
                sortable[i] = new SortableRow();
                sortable[i].row = rowsData.get(i);
                iRequest.setAttribute(this._xmlattr_opt_RowBeanName, sortable[i].row);
                sortable[i].value = this._xmlnode_1_unb_Columns[context.sortColumn].getSorter().getSortableValue(iRequest, sortable[i].row);
            }
            Arrays.sort(sortable, new RowsComparator(iRequest, context));
            for (i = 0; i < sortable.length; ++i) {
                rowsData.set(i, sortable[i].row);
            }
        }
        context.setRowsCount(rowsData.size());
        if (rowsData.size() == 0) {
            context.setPage(0);
        } else if (context.getFirstIndex() >= rowsData.size()) {
            int nbPages = (rowsData.size() + context.getRowsPerPage() - 1) / context.getRowsPerPage();
            context.setPage(nbPages - 1);
        }
        if (context.getFirstIndex() > 0) {
            int number = rowsData.size() - context.getFirstIndex();
            if (context.getRowsPerPage() > 0 && number > context.getRowsPerPage()) {
                number = context.getRowsPerPage();
            }
            rowsData = rowsData.subList(context.getFirstIndex(), context.getFirstIndex() + number);
        }
        return rowsData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowsComparator
    implements Comparator<SortableRow> {
        private HttpServletRequest _req;
        private ISorter _sorter;
        private int _asc = 1;

        public RowsComparator(HttpServletRequest iRequest, TableRenderingContextImpl context) {
            this._req = iRequest;
            this._sorter = context.getColumns()[context.getSortColumn()].getSorter();
            this._asc = context.getSortDirection() ? 1 : -1;
        }

        @Override
        public int compare(SortableRow iObj1, SortableRow iObj2) {
            try {
                return this._asc * this._sorter.compare(this._req, iObj1.value, iObj2.value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
    }

    private static class SortableRow {
        protected Object value;
        protected Object row;

        private SortableRow() {
        }
    }
}

